---
source: https://solar.lowtechmagazine.com/fr/2023/06/rebuilding-a-solar-powered-website/
author: Kris De Decker, Marie Otsuka, Roel Roscam Abbing, Marie Verdeil
translation: Marie Verdeil 
date: 13 juin 2023
---

# Reconstruire un site web alimenté par l'énergie solaire | LOW←TECH MAGAZINE

> Vous voyez ici une version entièrement reconstruite du site web solaire, qui vous permet maintenant de désactiver la compression par tramage et de consulter les images originales.

---

![Une capture d&rsquo;écran du fichier markdown de cette page.](https://solar.lowtechmagazine.com/fr/2023/06/rebuilding-a-solar-powered-website/images/dithers/solar-hugo-fr_dithered.png)

Une capture d’écran du fichier markdown de cette page.

Au cours des derniers mois, nous avons travaillé à la transition de notre site web solaire d’un générateur de site statique (Pelican) à un autre (Hugo). La plupart des lecteurs ne remarqueront pas tout de suite ces changements, car nous n’avons pas apporté d’ajustements majeurs au design. Néanmoins, la nouvelle plateforme nous a permis d’aborder certains problèmes sur la base des commentaires que nous avons reçus au fil des ans.

Le nouveau site web à énergie solaire a été conçu par [Marie Otsuka](https://motsuka.com/) et [Roel Roscam Abbing](https://roelof.info/), les mêmes personnes qui étaient à l’origine de la première version. [Marie Verdeil](https://verdeil.net/) nous a aidés tout au long du processus et a coordonné la migration du site web.

## Changement de plateforme

Le site web solaire original, [lancé en 2018](https://solar.lowtechmagazine.com/fr/2018/09/how-to-build-a-low-tech-website/), fonctionnait avec un générateur de site statique appelé [Pelican](https://getpelican.com/). Bien que cela reste un bon choix pour un site web relativement petit, la version solaire de Low-tech Magazine s’est considérablement développée au fil du temps. Au départ, elle ne présentait qu’une sélection du site web en anglais, mais elle s’est développée au fil du temps pour contenir non seulement davantage d’articles en anglais, mais aussi des traductions dans plus de cinq autres langues. L’organisation des articles et la publication des modifications sur un site web aussi gros étaient devenues un processus fastidieux. Par exemple, il fallait plus d’une heure pour régénérer le site à la suite de modifications, même si nous n’avions ajouté qu’un seul commentaire.

[Hugo](https://gohugo.io/) est un générateur de site statique écrit dans un langage de programmation plus rapide. Dans Pelican, la plupart des fonctionnalités dont nous avions besoin pour le site web, telles que la prise en charge de plusieurs langues et la compression d’images, étaient fournies sous la forme de plugins de qualité variable. Cela a conduit à des limitations au fil du temps. Avec Hugo, ces fonctionnalités sont mieux prises en charge dès le départ car elles sont au cœur du projet. En passant à Hugo, nous avons réussi à réduire le temps de génération sur le serveur de plus d’une heure à environ douze minutes. Sur un ordinateur portable moderne, la différence se situe entre plusieurs minutes et plusieurs secondes de génération. Cette différence de temps signifie également une différence dans la consommation d’énergie sur le serveur.

Outre la création plus rapide de sites web, Hugo permet une meilleure organisation du contenu et une plus grande souplesse dans la définition des catégories pour l’affichage de ce contenu. Cela nous a permis, par exemple, de créer des pages dédiées aux différents contributeurs et traducteurs du magazine. Cependant, bien que les deux projets utilisent des posts écrits en Markdown, la migration de tout le contenu de Pelican vers Hugo a été une tâche qui a pris beaucoup de temps. A la fois à cause de différences subtiles dans le format des métadonnées des articles et parce que notre configuration Hugo nécessite ses propres shortcodes pour permettre l’affichage d’images, de légendes et de liens. Nous avons converti la majorité des articles d’une plateforme à l’autre à l’aide d’un script personnalisé, mais il a fallu encore deux mois pour égaliser et réparer manuellement les incohérences dans le contenu.

## Modification du design

### Compteur de batterie

La nouvelle plateforme nous a permis d’aborder deux problèmes de conception qui revenaient régulièrement dans les commentaires au cours des dernières années. Le premier concerne le compteur de batterie, qui reflète l’état de la batterie de notre configuration de server hors réseau. Certaines personnes trouvaient qu’il interférait avec la lecture d’articles, en particulier lorsqu’il se trouvait à mi-chemin de la page. Le compteur de batterie reste un élément essentiel de notre conception, puisqu’il révéle l’infrastructure matérielle qui soutient le site web. Ainsi, il reste désormais en haut de la page et ne se déplace plus au fur et à mesure que l’on fait défiler un article en interférant avec le texte.

### Les images

La deuxième amélioration majeure concerne les images. La compression d’image par tramage (ndlt: la technique s’appelle « tramage ordonné ou tramage de Bayer ») fonctionne très bien pour de nombreuses images, et rend même les images en noir et blanc plus attrayantes. Cependant, certaines images perdent en clarté. C’est notamment le cas des graphiques, qui peuvent devenir illisibles s’ils n’ont pas été conçus en tenant compte de la compression. Pour d’autres images, les couleurs transmettent des informations qui sont perdues dans le processus de tramage.

La nouvelle conception permet au visiteur de désactiver la compression tramée des images individuellement, révélant ainsi la photo ou l’illustration originale. Ces images originales que nous montrons sont compressées de manière conventionnelle et sont légèrement plus lourdes que les images tramées. Le fait de les révéler augmente donc la charge sur notre serveur. Il reste à voir comment cela influencera la consommation d’énergie et le temps de fonctionnement du site web solaire.

En outre, les images ne sont plus en plein écran, ce qui est particulièrement avantageux lorsque le site est consulté sur un grand écran d’ordinateur.

## Code source

Comme c’était le cas avec le thème Pelican original, nous [publions le thème Hugo en tant que logiciel Libre](https://github.com/lowtechmag/solar_v2). Le thème web solaire original et les plugins restent disponibles, mais ne sont plus mis à jour ni maintenus.

## Faire fonctionner le magazine Low-tech sur un seul site web

Cette refonte majeure est l’avant-dernière étape vers le fonctionnement de Low-tech Magazine sur un seul site web (alimenté à l’énergie solaire). En effet, depuis le lancement du site solaire en 2018, l’ancien site web (en anglais) [est resté en ligne et à jour](https://www.lowtechmagazine.com/). Cette situation est gênante pour plusieurs raisons.

Tout d’abord, maintenir en ligne deux sites web au contenu identique n’est pas conforme à notre objectif de réduire l’empreinte écologique du magazine. D’autant plus que le site original - un site dynamique hébergé sur la plateforme de blogs _TypePad_ - n’est pas léger. Un deuxième site web fonctionnant sur le réseau électrique va également à l’encontre de l’objectif de mise hors ligne en cas de mauvais temps - l’ancien site web reste en ligne quel que soit la météo. Deuxièmement, la nécessité de mettre à jour deux sites web implique beaucoup de travail supplémentaire qu’il vaudrait mieux consacrer à la rédaction et à la recherche. La mise en page de chaque article doit être faite deux fois, sur des plateformes différentes. Les commentaires et les modifications apportées aux articles doivent également être mis à jour sur deux plateformes.

La qualité supérieure des images était l’une des principales raisons de maintenir l’ancien site à jour. Maintenant que les images originales peuvent être consultées sur le site web à énergie solaire, nous arrêtons la mise à jour de l’ancien site _Typepad_. Désormais, le nouveau contenu (y compris les commentaires sur les anciens articles) n’apparaît que sur le site alimenté par l’énergie solaire. Le site _TypePad_ restera en ligne jusqu’à l’été, lorsque nous prévoyons de déplacer la partie des archives qui n’a pas encore été convertie au format web statique. Il s’agit principalement d’articles et de pages datant des premiers jours.

Pour la plupart des autres langues (y compris le français), le passage au site web alimenté par énergie solaire a déjà été effectué et les sites web d’origine ont été fermés. La seule exception est le site web original en néerlandais, qui n’est plus mis à jour mais reste en ligne (également hébergé chez _TypePad_) pour que les articles plus anciens restent accessibles. En raison du grand nombre d’articles originaux sur le site néerlandophone, il sera le dernier site web original à disparaître, si tant est qu’il disparaisse. Il possède toujours [le design original de 2007](https://www.lowtechmagazine.be/).

## Facilité d’utilisation

Le nouveau design solaire n’apporte que des avantages aux lecteurs de Low-tech Magazine. Cependant, du côté de l’édition, le bilan est moins positif. Un plus grand confort d’utilisation pour les visiteurs s’est faite (en partie) au détriment d’une moins grande facilité d’utilisation pour l’auteur. Les shortcodes utilisés par Hugo sont [beaucoup plus compliqués](https://github.com/lowtechmag/solar_v2#image-shortcodes) que la syntaxe utilisée par Pelican, ce qui augmente le temps nécessaire à la mise en page d’un article. Cela annule en partie le temps gagné en n’ayant plus à mettre à jour le second site web.

Les sites web statiques sont beaucoup plus économes en énergie que les sites web dynamiques. Toutefois, les générateurs de sites statiques ont encore un long chemin à parcourir en termes de faclilité d’usage avant de devenir plus courants et de concurrencer des outils tels que WordPress. Au cours des cinq années qui se sont écoulées entre notre première version et celle-ci, nous avons été surpris de constater qu’aucune application robuste et facile d’utilisation pour les générateurs de sites statiques n’est apparue pour remplacer notre flux de travail actuel. Plusieurs projets existent, mais ils dépendent tous de services propriétaires (et/ou) hébergés sur des clouds. Une interface graphique utilisable pour les générateurs de sites statiques est encore l’endroit où des contributions clés à ce domaine peuvent être faites. Dans les mois à venir, nous essaierons d’améliorer les choses du côté de la publication, et comme toujours, vos commentaires et suggestions sont les bienvenus. N’hésitez pas à nous faire part des bugs ou des incohérences qui nous ont échappés lors de la migration. Merci à tous ceux qui ont soutenu ce projet au fil des ans.

Kris De Decker, Marie Otsuka, Roel Roscam Abbing, Marie Verdeil
