---
tags: [Reporterre,environnement,écologie,climat,biodiversité,luttes,alternatives]
source: https://reporterre.net/L-insoutenable-cout-ecologique-du-boom-de-l-IA
author: Reporterre
---

# L’insoutenable coût écologique du boom de l’IA

> ## Excerpt
> L'intelligence artificielle est très gourmande en énergie et en matières premières. Sans remettre en cause leur activité, ses promoteurs s’en remettent à une version améliorée de l’IA, supposément plus « verte » et plus « sobre ».

---
L’intelligence artificielle est très gourmande en énergie et en matières premières. Sans remettre en cause leur activité, ses promoteurs s’en remettent à une version améliorée de l’IA, supposément plus « verte » et plus « sobre ».

IA ne rime pas avec climat. Le boom actuel du secteur de l’intelligence artificielle (IA) met notamment en péril les plans _« net zéro »_ des grandes entreprises technologiques. Un [récent graphique](https://x.com/DigiEconomist/status/1799840140782924174/photo/1) tiré du bilan trimestriel de Microsoft montre qu’à mesure que ses investissements dans l’IA explosent, le géant technologique s’éloigne de la neutralisation de ses émissions carbone d’ici 2030.

D’après [une projection](https://www.iea.org/reports/electricity-2024/executive-summary?ref=disconnect.blog) de l’Agence internationale de l’énergie, l’industrie mondiale des centres de données, de l’IA et des cryptoactifs devrait doubler sa consommation d’électricité d’ici 2026, générant un surplus de 37 milliards de tonnes de CO<sub>2</sub> dans l’atmosphère. Ce qui représente l’équivalent de la consommation annuelle d’un pays comme le Japon. En France, ce seul secteur devrait générer, chaque année, 50 millions de tonnes de CO<sub>2</sub> en 2050, [alertent](https://www.arcep.fr/fileadmin/user_upload/pole-numerique-arcep-arcom/referentiel-usages-numeriques-arcep-arcom_avril2023.pdf) les autorités de régulation Arcep et Arcom.

Sam Altman, le patron d’OpenAI, l’entreprise qui a popularisé l’usage des IA génératives avec son programme ChatGPT, [a reconnu](https://www.youtube.com/watch?v=xUoAhu2hlWo) en janvier dernier ne pas réellement _« savoir mesurer les besoins en énergie de cette technologie »_, alimentant une interrogation lancinante : le boom des IA est-il susceptible d’aggraver les dérèglements du climat ?

## Course à la puissance de calcul

Électricité, eau, terres rares, _hardware_ (l’ensemble des composantes d’un ordinateur) : l’empreinte matérielle de cette industrie numérique est longtemps restée un angle mort. À ce jour, il demeure _« très difficile de disposer de données robustes pour quantifier le poids écologique réel de cette industrie »_, met en garde Valentin Goujon, spécialiste de l’intelligence artificielle et doctorant en sociologie au Medialab de Sciences Po. En cause ? _« L’opacité des géants du numérique qui communiquent très peu sur leurs infrastructures de calcul, considérées comme des actifs stratégiques. »_

Une observation des ordres de grandeur disponibles donne toutefois le tournis. Car le boom de l’IA est avant tout une course à la puissance de calcul. Et c’est en premier lieu le secteur des _data centers_ qui est en ébullition. La construction de centres de données de _« grande capacité »_ devrait tripler d’ici six ans, a évalué le cabinet [Synergy Research](https://www.networkworld.com/article/957440/hyperscale-data-center-capacity-on-pace-to-triple-over-next-six-years.html?ref=disconnect.blog). Une courbe ascendante qui se répercute sur la demande en électricité.

 ![](https://reporterre.net/IMG/jpg/google_data_center__council_bluffs_iowa__49062863796_1_.jpg)

Data centers de Google dans l’Iowa, aux États-Unis. _Wikimedia Commons/CC BY 2.0/Chad Davis_

En France, cette accélération est déjà très concrète, notamment en Île-de-France. Le seul secteur des _data centers_ pourrait mobiliser la puissance de cinq à sept réacteurs nucléaires d’ici 2030, dit Cécile Diguet, directrice du département transformations urbaines de l’agence d’urbanisme d’Île-de-France, dans les colonnes du _[Monde](https://www.lemonde.fr/economie/article/2024/06/14/derriere-l-ia-la-deferlante-des-data-centers_6239694_3234.html)_. Et de mettre en garde : _« Attention à ne pas fragiliser le réseau comme en Irlande. »_

## Réseau saturé, stress hydrique et terres rares

En Irlande, un pays qui se veut à l’avant-garde de cette industrie, la multiplication des centres de données est susceptible de mobiliser un tiers de la production électrique totale du pays en 2026, selon une projection de l’Agence internationale de l’énergie, relayée par le _[Guardian](https://www.theguardian.com/world/2024/feb/15/power-grab-hidden-costs-of-ireland-datacentre-boom)_. En cas de choc de demande sous l’effet de phénomènes saisonniers, comme un hiver rude ou une tempête, cette forte demande pourrait conduire à [une saturation du réseau électrique](https://reporterre.net/Trop-de-data-centers-l-Irlande-risque-la-panne-electrique).

La tension déjà très palpable aux États-Unis, où la construction de centres de données explose, générant un [triplement anticipé](https://www.linkedin.com/pulse/impact-genai-electricity-how-fueling-data-center-boom-vivian-lee/) de la consommation électrique du secteur pour 2030. Cela alimente les inquiétudes citoyennes, en particulier parce que certains États comme le Texas doivent également supporter la [consommation très importante](https://www.nytimes.com/2023/04/09/business/bitcoin-mining-electricity-pollution.html) des [mineurs de Bitcoins](https://reporterre.net/Le-bitcoin-monnaie-virtuelle-mais-gouffre-environnemental-reel).

[**Lire aussi :** Data centers : leur consommation d’eau va exploser](https://reporterre.net/Data-centers-leur-consommation-d-eau-va-exploser)

À la demande en électricité s’ajoute celle en eau, abondamment utilisée pour refroidir les équipements. Google rapporte ainsi pour 2023 une augmentation nette de sa consommation en eau de 17 % de plus qu’en 2022, tandis que chez Microsoft, on parle de [34 % de hausse](https://apnews.com/article/chatgpt-gpt4-iowa-ai-water-consumption-microsoft-f551fde98083d17a7e8d904f8be822c4) en 2021. Or l’eau n’est pas la seule matière première en tension.

Il faut également considérer, en amont de la chaîne de production, la demande en minerais et terres rares qui entrent dans la composition des puces et microprocesseurs, comme [ceux fabriqués](https://www.lemonde.fr/economie/article/2024/06/19/cette-exuberance-des-marches-qui-place-desormais-nvidia-devant-microsoft-tient-en-trois-mots-intelligence-artificielle-generative_6241365_3234.html) par le mastodonte étasunien Nvidia. Actuellement, c’est en particulier le cuivre qui voit sa production _« siphonnée »_ par l’industrie de l’IA, selon le _[Wall Street Journal](https://www.wsj.com/articles/ai-siphons-copper-supplies-needed-for-green-transition-8fef79e6)_.

Or ces métaux précieux sont extraits dans des conditions sociales et environnementales souvent désastreuses. En Birmanie, cette industrie alimente un _« pillage généralisé des ressources naturelles »_, s’alarme l’ONG [Global Witness](https://www.globalwitness.org/en/campaigns/natural-resource-governance/myanmars-poisoned-mountains/). À [Taïwan](https://reporterre.net/A-Taiwan-la-secheresse-menace-la-production-de-puces-electroniques), principal producteur mondial de microélectronique de pointe, cette industrie stratégique accentue le stress hydrique d’un pays régulièrement frappé par la sécheresse, montre le chercheur [Gauthier Roussilhe](https://gauthierroussilhe.com/articles/eau-et-puces-electroniques-l-avenir-climatique-et-industriel-de-taiwan).

## Embryons de régulation

À l’heure où les dérèglements climatiques s’aggravent, le défi environnemental posé par le boom de l’IA ne peut plus être ignoré. Aux États-Unis, [un texte de loi](https://www.congress.gov/bill/118th-congress/senate-bill/3732/text) baptisé Artificial Intelligence Environmental Impacts Act a été introduit début 2024 au Congrès : il propose une régulation adaptée aux conséquences écologiques du secteur. Un volontarisme affiché qui contraste avec la timidité de l’IA Act européen. Celui-ci, s’il offre un premier cadre de régulation, ne se préoccupe pas de son coût environnemental.

En France, le groupement Ecolab de l’État s’est saisi du sujet et propose [une approche](https://greentechinnovation.fr/2024/01/17/lancement-du-groupe-de-travail-impact-environnemental-de-lia-organise-en-collaboration-avec-lafnor/) de l’_« IA frugale »_ en réponse à la gourmandise de l’IA en énergie et en matières premières. Pour cela, l’agence entend s’appuyer sur des pépites françaises de la GreenTech, des entreprises engagées pour mettre au point des technologies plus vertes et plus sobres.

Au niveau international, l’engagement pour réduire le coût environnemental de l’intelligence artificielle est porté par la Green Software Foundation, qui rassemble des acteurs publics comme les principaux industriels du secteur, épaulés par les grands cabinets de conseil.

## Géoingénierie comme palliatif

Les patrons des principaux géants technologiques impliqués dans la course à l’IA semblent s’éveiller à la problématique du coût environnemental de leur industrie. Mais pour eux, l’enjeu demeure principalement d’ordre financier. Le patron d’Alphabet, la maison-mère de Google, a reconnu dans [un échange avec Reuters](https://www.youtube.com/watch?v=xUoAhu2hlWo) qu’intégrer Bard, leur chatbot doté d’IA dans le moteur de recherche, conduirait à multiplier par dix le coût par requête. En effet, pour une requête simple, Google mobilise les données déjà indexées sur internet, alors qu’ajouter une couche d’IA pour le même service sollicite une puissance de calcul bien supérieure. À service égal, l’IA utilise trente fois plus d’énergie, [note](https://www.scientificamerican.com/article/what-do-googles-ai-answers-cost-the-environment/) la chercheuse Sasha Luccioni de l’entreprise d’IA Hugging Face.

[Interrogé](https://disconnect.blog/sam-altmans-self-serving-vision-of-the-future/) au Forum économique mondial sur le futur d’une industrie aussi gourmande en énergie et en matières premières, Sam Altman a choisi de s’en remettre au progrès scientifique et à l’innovation. La seule manière, selon lui, d’absorber la demande exponentielle de son industrie. Il se déclare confiant dans les principes de la _« [géoingénierie](https://reporterre.net/La-geoingenierie-solaire-ou-les-apprentis-sorciers-du-climat) comme palliatif »_.

Une déclaration aux accents technosolutionnistes qui ne surprend pas Loup Cellard, chercheur membre du Medialab de Sciences Po et rédacteur en chef de la revue critique _Tèque_ : _« La crise climatique est perçue comme une crise de l’efficacité. Les industriels de l’IA s’en remettent donc à des solutions technologiques pour optimiser le secteur, sans jamais questionner sa fuite en avant. »_
