---
source: https://wildproject.org/livres/plurivers?noimages
author: George Caffentzis
tags: ordinateurs, Foxconn, exploitation, dégâts environnementaux
---


# Outils numériques

George Caffentzis

Alors que le développement pousse à l’adoption d’outils numériques dans presque toutes les sphères de la vie quotidienne, l’expression « ordinateurs de sang » a été proposée. Celle-ci fait l’analogie avec les « diamants de sang », en raison du nombre croissant de preuves attestant du caractère sanglant de la production d’ordinateurs. Plus spécifiquement, un lien existe entre certaines entreprises du numérique et des milices responsables du déplacement et du meurtre de millions de personnes en République démocratique du Congo. L’expression « ordinateurs de sang » date d’un rapport publié en 2009 par l’ong anglaise Global Witness, intitulé « Faced with a Gun, What Can You Do? » (« Que peux-tu faire sous la menace d’une arme à feu ? »). Ce rapport accusait de grandes entreprises minières, métallurgiques et électroniques de se faire les complices silencieuses des violences infligées par des groupes armés qui opèrent principalement dans les provinces riches en minerais du Nord et du Sud-Kivu, et qui « forcent fréquemment des civils à extraire des minerais, en leur extorquant des taxes et en refusant de les payer » (Dias, 2009). Le coltan est particulièrement préoccupant, étant un minéral indispensable dans la production des smartphones et des ordinateurs portables. L’objectif du rapport de Global Witness, et des autres rapports qui l’ont suivi, était d’alerter les consommateurs et consommatrices et les autorités quant au besoin de contrôles plus stricts sur le processus permettant à de tels minerais d’atteindre le marché international et les acheteurs. À la suite de campagnes organisées en 2010 sous le slogan « _No Blood for my Mobile_ » (« Pas de sang pour mon portable »), le Congrès américain a voté une loi, dite loi Dodd-Frank, qui exige des entreprises plus de transparence sur l’origine de leurs minerais. Il est admis qu’il n’existe pas de téléphone ou d’ordinateur dont la production n’implique pas de zone de conflit, étant donné que les « canaux par lesquels circule le coltan sont […] labyrinthiques et souvent clandestins » (Brophy et de Peuter, 2014 : 63).

Pourtant, les grandes problématiques concernant la place des outils numériques dans la production sociale et les luttes citoyennes restent insuffisamment traitées par les mouvements pour la justice sociale. Bien trop souvent, les technologies numériques font l’objet de louanges sans discernement, en tant qu’outils d’organisation clés permettant de relier des militantes et des militants dispersés aux quatre coins du monde, et en tant que moyens de discussion et de mobilisation rapides et efficaces. Mais leurs coûts écologiques et sociaux ne sont pas ou peu mentionnés. Comme le remarque le théoricien Saral Sarkar dans E_co-Socialism or Eco-Capitalism?_, la production d’outils numériques représente un désastre environnemental : « Le fait que les ordinateurs et la majorité des biens électroniques deviennent toujours plus petits constitue aussi un inconvénient pour l’environnement. De tels produits sont hautement complexes et composés d’un mélange de nombreux matériaux. La miniaturisation fait qu’il est de plus en plus difficile et parfois même impossible de séparer ces matériaux, ce qui entrave le recyclage » (Sarkar, 1999 : 128). Il ajoute que l’Allemagne, à elle seule, génère 120 000 tonnes de déchets d’ordinateurs chaque année, qui contiennent tous des substances hautement toxiques.

Un élément central de l’aura idéologique d’autocongratulation émanant de l’industrie numérique est sa supposée « propreté ». Les porte-parole du secteur mettent constamment en avant le contraste entre, d’un côté, leur révolution industrielle de l’information et la dématérialisation, et de l’autre, l’époque sale des moteurs à vapeur et à combustion interne alimentés au charbon et au pétrole. Cette idéologie hérite – malgré lui – du théoricien originel de l’ordinateur, Alan Turing, qui, dans les années 1930, décrivait cette machine en termes purement abstraits. Depuis cette perspective, il a réussi à montrer l’existence de limites internes au pouvoir computationnel, tenant au fait qu’il existe des chiffres qu’aucun ordinateur ne peut calculer. Mais Turing ne se préoccupait aucunement de l’origine des matériaux composant un ordinateur ; du type d’énergie dont il dépend ; ou de la façon de gérer la chaleur résiduelle générée par son fonctionnement. Comme l’a écrit Charles Henry Bennett, « les ordinateurs peuvent être conçus comme des moteurs transformant l’énergie libre en chaleur résiduelle et en travail mathématique » (Gleick, 2011 : 360). Le besoin en énergie libre et son corollaire, la chaleur résiduelle, s’intensifient inévitablement étant donné que l’utilisation des technologies de communication et des technologies informatiques occupe plus que jamais une place centrale dans le cycle de production et de reproduction du système capitaliste.

Le fait que les produits électroniques et numériques soient marqués du sceau de la destruction est également confirmé par les conditions d’exploitations notoires dans lesquelles ils sont 139produits. En Chine continentale, les ouvriers et ouvrières des usines Foxconn – le plus grand producteur mondial d’ordinateurs – ont souvent menacé de se suicider en protestation contre les longues heures de travail et les salaires de famine. Bien sûr, les outils numériques ont aussi été utilisés pour renforcer les luttes politiques à travers le monde (Brophy et de Peuter, 2014 : 66). Néanmoins, les militants et les universitaires devraient éviter de célébrer la numérisation en laissant dans l’ombre les conditions dans lesquelles ces technologies sont produites. Par exemple, il est problématique d’affirmer, comme certains milieux radicaux le font, qu’Internet représente un nouveau type de commun, alors que sa production matérielle repose sur la destruction de nombreux communs naturels, l’expropriation et la contamination toxique de vastes étendues de terres, et le déplacement ou le meurtre de celles et ceux qui y vivaient auparavant.

Ces préoccupations sont d’autant plus importantes que la question de la technologie s’avère fondamentale pour tous les projets de transformation du 21e siècle. Il est crucial de développer une vision globale sur la question des ordinateurs, en interrogeant à la fois leurs conditions de production et les effets associés à leurs usages. Une ligne directrice dans cet effort devrait être la reconnaissance du fait que la technologie capitaliste a été historiquement produite pour contrôler les luttes de la classe ouvrière et détruire les formes d’organisation sur lesquelles se fondent ces résistances. La numérisation ne peut pas être simplement réappropriée et réorientée vers des buts différents.

## Pour aller plus loin

* Brophy, Enda et Greig de Peuter (2014), « Labors of Mobility: Communicative Capitalism and the Smartphone Cybertariat », dans Andrew Herman, Jan Hadlaw et Thom Swiss (dir.), _Theories of the Mobile Internet: Materialities and Imaginaries_, New York : Routledge.
* Dias, Elizabeth (2009), « First Blood Diamonds, Now Blood Computers? », _Time_, 24 juillet, www.time.com
* Gleick, James (2011), _The Information: A History, A Theory, A Flood_, New York : Pantheon Books.
* Sarkar, Saral (1999), _Eco-Socialism or Eco-Capitalism? A Critical Analysis of Humanity’s Fundamental Choices_, Londres : Zed Books.

George Caffentzis est professeur émérite au département de philosophie de l’université du Southern Maine à Portland. Il est l’auteur de In Letters of Blood and Fire:Work, Machines, and the Crisis of Capitalism (pm Press, 2013) et de No Blood for Oil! Essays on Energy, Class Struggle, and War 1998-2016 (Autonomedia, 2017).