---
source: https://wildproject.org/livres/plurivers?noimages
author: Harry Halpin
tags: ordinateurs, logiciel, propriété intellectuelle, communs
---

# Logiciel libre

Harry Halpin

Alors que le monde est de plus en plus tissé en un réseau dense d’ordinateurs interconnectés, la question centrale de notre époque est en train de devenir une question technologique : comment maintenir la liberté dans un monde qui est de plus en plus dirigé non pas par des humains, mais par des logiciels ? Le logiciel libre apporte une réponse à cette question en actualisant la notion traditionnelle de liberté, antérieure au numérique, pour y inclure la dépendance de l’humanité à l’égard du logiciel. La question à laquelle toute forme future de politique doit répondre n’est pas seulement la préservation de la liberté humaine, mais son expansion via un plus grand contrôle populaire autonome de l’infrastructure informatique, par les utilisateurs eux-mêmes. À l’heure actuelle, les capacités liées à l’Internet sont monopolisées par quelques grandes entreprises de la Silicon Valley, comme Google, Apple, Facebook et Microsoft. Nos capacités cognitives étendues s’exercent par l’intermédiaire de logiciels qui sont en fait privatisés. Cela marque un tournant décisif dans le capitalisme, le travail numérique sous forme de « programmation » devenant la nouvelle forme hégémonique de travail. Cela ne signifie pas que les emplois traditionnels en usine et ceux liés à l’extraction des ressources ont été rendus obsolètes – loin de là ! Cependant, ce type de travail est soumis à des conditions de plus en plus brutales et précaires dans les pays de la « périphérie » et dans les zones d’exclusion des pays du centre. L’absence d’investissement dans les logiciels, au profit de la production industrielle et de l’extraction des ressources, fait des « pays en voie de développement » de simples rouages fournissant des biens à faible marge et une main-d’œuvre bon marché, pendant que le capitalisme se réorganise autour des logiciels. Les logiciels mènent à l’automatisation, au remplacement du travail humain par des machines. Le langage qui coordonne celles-ci à l’échelle mondiale est le code. L’ordinateur est défini comme une machine de Turing universelle, une machine qui est infiniment flexible par rapport à d’autres outils spécialisés, car la même machine peut être réorganisée pour être plus efficace, ou reprogrammée pour de nouvelles capacités. Le cœur du capitalisme n’est plus l’usine, mais le code.

Et si les gens pouvaient contrôler le code eux-mêmes ? Le « logiciel libre » inscrit quatre libertés fondamentales dans le code lui-même :
* la liberté de faire fonctionner le programme comme vous le souhaitez, pour n’importe quel usage ;
* la liberté d’étudier le fonctionnement du programme et de le modifier pour qu’il effectue vos tâches informatiques comme vous le souhaitez ;
* la liberté de redistribuer des copies, donc d’aider les autres ; 
* la liberté de distribuer aux autres des copies de vos versions modifiées.

Ces libertés signifient que les gens peuvent contrôler les logiciels pour leurs propres besoins en ayant accès au code source – comme le dit la Free Software Foundation, « le _free software_ est une question de liberté, pas de prix » (Stallman, 2017). Le logiciel libre est un programme politique qui va au-delà de l’_open source_ ou de l’_open access_, bien qu’il offre un accès ouvert au code, nécessaire à la liberté.

Le hacker Richard Stallman a inventé le logiciel libre au Massachussets Institute of Technology (mit), comme un hack dans la loi américaine sur le droit d’auteur, constatant que la culture de partage des logiciels développée par les hackers était limitée par des entreprises commerciales comme Microsoft. Afin de créer une résistance juridiquement contraignante à ces nouvelles _enclosures_ cognitives, Stallman a conçu la General Public License (gpl). Étant donné que le droit d’auteur d’un logiciel est attribué par défaut au développeur, celui-ci peut accorder une licence à un nombre illimité de personnes et préserver ainsi les quatre libertés fondamentales pour la postérité. La General Public License requiert que toutes les œuvres dérivées utilisent également cette licence, de sorte que les restrictions traditionnelles du droit d’auteur se transforment en un _copyleft_ qui exige que les quatre libertés soient accordées. D’autres licences open source, telles que la licence du mit ou la plupart des licences Creative Commons – qui attribuent directement le droit d’auteur au domaine public –, n’empêchent pas que des œuvres dérivées finissent par faire l’objet d’une appropriation. La General Public License permet non seulement de sécuriser une œuvre logicielle particulière pour préserver les capacités humaines, mais elle fait aussi en sorte que les logiciels mis en commun puissent se développer de manière virale. La General Public License a été une licence et une méthodologie logicielle qui a remarquablement réussi. Par exemple, GNU/Linux fait fonctionner aujourd’hui une grande partie de l’architecture d’Internet, et même Android de Google repose sur un noyau de logiciel libre, bien que Google externalise des composants vitaux dans son _cloud_ propriétaire.

Le logiciel libre résout des problèmes jusqu’alors insurmontables pour celles et ceux qui recherchent la souveraineté technologique à l’échelle individuelle et collective. Premièrement, il permet aux programmeurs d’établir de nouvelles formes de solidarité sociale à travers la programmation collective du code, par opposition au développement des logiciels propriétaires qui est maintenu dans le silo d’une seule entreprise. Deuxièmement, les utilisateurs de logiciels libres peuvent par définition devenir euxmêmes des programmeurs, car ils ont la possibilité d’apprendre comment programmer et apporter des modifications au code. Troisièmement, l’_open source_ est la seule garantie de sécurité, car il permet à des experts de contrôler le code. Il n’y a pas de frais de licence et les mises à jour de sécurité sont gratuites, ce qui empêche de nombreuses cyberattaques. Enfin, bien que le code puisse être conservé « _in the cloud_ », c’est-à-dire hébergé sur les ordinateurs d’autres personnes, des versions de la General Public License, telles que la GPL Affero, peuvent garantir que le code source des logiciels qui fonctionnent sur des serveurs soit disponible en tant que partie des communs. La General Public License est une condition préalable à la décentralisation d’Internet et à la remise en cause du pouvoir du capitalisme informationnel.

Le logiciel libre est vital pour l’avenir des mouvements sociaux. On ne peut pas revenir à une vie préindustrielle, sans logiciels et sans ordinateurs. Les ordinateurs sont une formalisation mathématique d’une théorie philosophique abstraite de la causalité dans le monde matériel, et ils peuvent donc prendre de nombreuses formes, de l’informatique quantique à l’informatique biologique, et à l’avenir, espérons-le, des formes qui s’intégreront à l’écologie. Rejeter entièrement l’ordinateur reviendrait – si l’on pousse cette logique à l’extrême – à rejeter toute machinerie et à condamner l’humanité à une corvée perpétuelle et au provincialisme – un avenir peu prometteur. Il est tout aussi naïf d’imaginer que le capitalisme va se transformer rapidement en une utopie socialiste sans travail grâce à la diffusion des ordinateurs. De la diffusion d’Indymedia à la téléphonie mobile de Rhizomatica gérée communautairement à Oaxaca, en passant 345par le plan d’infrastructure écologique autonome qui utilise des logiciels libres au Rojava, le logiciel libre a aidé discrètement les mouvements sociaux pendant des décennies, en fournissant les logiciels sous-jacents nécessaires aux luttes. En termes de post-développement, ce qu’il faut, c’est une stratégie qui augmente à la fois la liberté individuelle et la liberté collective par l’extension technologique des capacités humaines. Comme ces capacités dépendent de plus en plus des ordinateurs, le logiciel libre fournit une stratégie nécessaire dans la lutte pour retirer les logiciels des _enclosures_ – et donner le pouvoir au peuple. 

## Pour aller plus loin 

* Système d’exploitation gnu, www.gnu.org/licenses
* Gandy, Robin (1995 [1988]), « The Confluence of Ideas in 1936 », dans Rolf Herken (dir.), _The Universal Turing Machine: A Half-Century Survey_, Vienne : Springer-Verlag.
* Levy, Steven (2013 [1984]), _L’Éthique des hackers,_ Paris : Globe. 
* Moglen, Eben (1999), « Anarchism Triumphant: Free Software and the Death of Copyright », _First Monday_, vol. 4, no 8.
* Stallman, Richard (2017), « Qu’est-ce que le logiciel libre ? », www.gnu.org/philosophy/free-sw.html

Harry Halpin est chercheur au mit Sociotechnical Systems Research Center et a été coordinateur de projet à l’Institut national de recherche en sciences et technologies du numérique à Paris. Il a auparavant travaillé pour le W3C sur les normes de sécurité, avant de démissionner en raison des problèmes liés au _Digital Rights Management_ (drm). Il est l’auteur de _Social Semantics: The Search for Meaning on the Web_ (Springer, 2013) et a dirigé l’ouvrage _Philosophical Engineering: Toward a Philosophy of the Web_ (Wiley, 2013).