---
source: https://www.terrestres.org/2020/02/06/placer-des-obstacles-sur-la-voie/
author: Ursula K. Le Guin
tags: Ecoféminisme, Féminisme, Récits, Science-fiction, Territoires
---

# La théorie de la Fiction-Panier

Ursula K. Le Guin

_Traduit de l’anglais (US) par Aurélien Gabriel Cohen_

Dans les régions tempérées et tropicales où les hominidés sont devenus des êtres humains, l’alimentation de ces espèces était principalement d’origine végétale. Au Paléolithique, au Néolithique et à l’époque préhistorique, entre 65 et 80 % de ce que mangeaient les êtres humains dans ces régions était cueilli ; la viande ne constituait l’alimentation de base que dans l’extrême Arctique. Les chasseurs de mammouth occupent certes de façon spectaculaire les grottes et les esprits, mais ce que nous devions réellement faire pour rester gras et vivant, c’était cueillir des graines, des racines, des bourgeons, des jeunes pousses, des feuilles, des noix, des baies, des fruits, et des céréales, auxquels s’ajoutaient la collecte d’insectes et de mollusques, ainsi que le piégeage d’oiseaux, de poissons, de rongeurs, de lapins et autre menu fretin sans défense afin d’augmenter les apports de protéines. Et nous n’avions même pas besoin d’y travailler dur – beaucoup moins durement en tout cas que des paysans asservis dans le champ d’un autre depuis l’invention de l’agriculture, beaucoup moins que des travailleurs salariés depuis l’invention de la civilisation. Un humain préhistorique moyen pouvait vivre bien en travaillant environ quinze heures par semaine.

Quinze heures par semaine consacrées à la subsistance, cela laisse beaucoup de temps pour d’autres choses. Tellement de temps, qu’il est possible que quelques agités, qui n’avaient pas un bébé dans les parages pour rendre leurs vies plus vivantes, ou pas de talent pour fabriquer, cuisiner ou chanter, ou rien de très intéressant à quoi penser, ceux-là ont pu décider un jour de filer chasser des mammouths. Dès lors, les chasseurs habiles pouvaient rentrer en titubant sous un fardeau de viande, les bras pleins d’ivoire, et avec une histoire. Mais ce n’est pas la viande qui faisait la différence. C’était l’histoire.

Il est difficile de faire un récit vraiment captivant en racontant la manière dont j’ai arraché une graine d’avoine sauvage de son enveloppe, et puis une autre, et puis une autre, et puis une autre, et puis une autre, et comment j’ai ensuite gratté mes piqûres d’insectes, et Ool a dit quelque chose de drôle, et nous sommes allés jusqu’au ruisseau pour boire, nous avons regardés les tritons pendant un moment, et puis j’ai trouvé un autre coin d’avoine… Non, vraiment ça ne tient pas la comparaison avec la manière dont j’ai plongé ma lance au plus profond du flanc titanesque et poilu, tandis que Oob, empalé sur l’une des gigantesques défenses, se tordait en hurlant, et le sang jaillissait partout en de pourpres torrents, et Boob a été transformé en gelée lorsque le mammouth lui est tombé dessus alors que je tirai ma flèche infaillible à travers son œil pour pénétrer son cerveau.

Cette histoire-là ne contient pas seulement de l’Action, elle possède un Héros. Et les Héros sont puissants. Avant que vous ne vous en soyez rendu compte, les hommes et les femmes dans le coin d’avoine sauvage, leurs enfants, l’habileté des faiseurs, les pensées des pensifs et les chants des chanteurs ne sont plus que des éléments de la nouvelle histoire, appelés au service de la saga du Héros. Mais cette histoire n’est pas leur histoire. C’est la sienne.

Lorsqu’elle préparait le livre qui finira par devenir _Trois Guinées_, Virginia Woolf écrivit une rubrique « Glossaire » dans son carnet. Elle avait imaginé réinventer la langue anglaise avec une nouvelle visée, afin de raconter une histoire différente. L’une des entrées de ce glossaire définit l’_héroïsme_ comme un « botulisme ». Et le _héros_, dans le dictionnaire de Woolf, devient une « bouteille ». Le héros comme bouteille, voilà déjà une sévère réévaluation. Je propose à présent de considérer la bouteille comme un héros.

Pas seulement la bouteille de gin ou de vin, mais la bouteille au sens ancien d’un contenant en général, d’une chose qui contient autre chose.

Si vous n’avez rien pour l’y placer, la nourriture vous échappera – même quelque chose d’aussi peu combatif et dégourdi que de l’avoine. Tant qu’elle est à portée de main, vous en mettez autant que possible dans le premier de tous les contenants, votre estomac. Mais qu’en est-il du lendemain matin, lorsque vous vous réveillez dans le froid et la pluie ? Ne serait-il pas bon d’avoir alors quelques poignées d’avoine à mâcher et à donner à la petite Oom pour la faire taire ? Oui, mais comment faire pour en transporter davantage qu’une ventrée et qu’une poignée jusqu’à la maison ? Alors vous vous levez, vous allez sous la pluie jusqu’à ce satané coin d’avoine boueux – mais ne serait-il pas bon d’avoir quelque chose pour porter bébé Oo Oo, afin de pouvoir ramasser les graines avec les deux mains ? Une feuille une calebasse une coquille un filet un sac une écharpe une hotte un pot une boîte un contenant. Un réceptacle. Un récipient.

> « Le premier équipement culturel a probablement été un récipient. (…) De nombreux théoriciens ont le sentiment que les premières inventions culturelles furent forcément d’une part un contenant, destiné à recueillir les denrées collectées, et puis une sorte d’écharpe ou de filet de portage. »

Ainsi parle Elizabeth Fisher dans _Women’s Creation_. Mais non, ce n’est pas possible. Où est donc passé cette chose merveilleuse, grosse, longue et dure – un os, je crois – avec laquelle l’Homme-Singe du film frappait quelqu’un pour la première fois, avant que, grognant d’extase à l’idée d’avoir commis le premier vrai meurtre, il ne l’envoie à travers le ciel où la chose tourbillonnait jusqu’à devenir un vaisseau spatial, enfonçant les portes du cosmos pour le féconder et concevoir ainsi, à la fin du film, un adorable fœtus, un garçon évidemment, dérivant à travers la Voie Lactée sans (curieusement) aucun utérus ou matrice d’aucune sorte ? Je n’en sais rien. Et je n’en ai rien à faire. Ce n’est pas cette histoire que je raconte. Nous l’avons entendu cette histoire, nous avons tous entendu parler des bâtons, des lances et des épées, de tous ces instruments avec lesquels on frappe, on perce et on cogne, de ces choses longues et dures. En revanche, nous n’avons rien entendu sur la chose dans laquelle on met d’autres choses, sur le contenant et les choses qu’il contient. En voilà une nouvelle histoire. En voilà une nouvelle.

Tout cela est bien ancien pourtant. Avant – et dès lors que l’on y pense, certainement bien avant – l’invention de l’arme, cet outil tardif, dispendieux et superflu ; bien avant le couteau si utile et la hache ; parallèlement aux indispensables faux, meule et bâton à fouir – car à quoi bon arracher beaucoup de pommes de terre si vous n’avez rien pour trimballer jusqu’à la maison celles que vous ne pouvez pas manger sur place ; en même temps ou avant l’outil qui canalise l’énergie vers l’extérieur, nous avons fabriqué l’outil qui ramène l’énergie à la maison. Cela fait sens pour moi. J’adhère ainsi à ce que Fisher a appelé la Théorie du Panier de l’évolution humaine.

Cette théorie ne se contente pas d’expliquer de larges pans d’obscurité théorique, et d’éviter de vastes zones d’absurdité théorique (largement peuplées de tigres, de renard et d’autres mammifères hautement territoriaux). Elle m’ancre aussi personnellement dans la culture humaine comme jamais je ne l’avais senti auparavant. Je n’ai jamais pensé que j’avais, ou même que je voulais une part de tout ça, tant que l’on expliquait l’origine et le développement de la culture à travers l’invention et l’usage d’objets longs et durs, destinés à pénétrer, frapper et tuer. (« Ce que Freud a faussement pris pour un manque de civilisation chez la femme est en réalité un manque de _loyauté_ à l’égard de la civilisation » remarquait Lillian Smith). La société, la civilisation dont parlaient tous ces théoriciens, c’était évidemment la leur : ils la possédaient et ils l’aimaient. Ils étaient humains, pleinement humains, pénétrant, frappant, enfonçant, tuant. Voulant être un humain moi aussi, j’ai cherché des preuves que je l’étais. Mais s’il fallait pour cela fabriquer une arme et m’en servir pour tuer, alors il devenait évident que j’étais particulièrement déficiente comme humain, peut-être même pas un humain du tout.

C’est exact, dirent-ils. Voilà ce que tu es : une femme. Potentiellement pas un humain du tout, et certainement un humain déficient. Maintenant tais-toi, nous allons continuer à raconter l’Histoire de l’Ascension de l’Homme-Héros.

Allez-y, dis-je, tandis que je m’aventurai à travers l’avoine sauvage, avec Oo Oo en écharpe et la petite Oom dans le panier sur mon dos. Continuez à raconter comment le mammouth est tombé sur Boob, comment Cain est tombé sur Abel, comment la bombe est tombée sur Nagasaki, comment la gelée ardente est tombée sur les villageois, comment les missiles vont tomber sur l’Empire du Mal et toutes les autres étapes de l’Ascension de l’Homme.

Si c’est faire quelque chose d’humain que de mettre une chose que vous voulez dans un sac, parce que cette chose est utile, comestible ou belle, de la placer dans un panier, dans de l’écorce ou dans une feuille enroulée, dans un filet tissé avec vos propres cheveux, ou dans tout ce que vous voulez, et ensuite de ramener à la maison cette chose-là, dans une maison qui n’est qu’une autre sorte de grande poche ou de grand sac, un contenant pour les gens, et que plus tard vous ressortez cette chose pour la manger, la partager, la conserver pour l’hiver dans un récipient plus solide, la mettre dans le sac-médecine, sur l’autel ou dans le musée, à l’endroit vénéré, dans l’espace qui contient ce qui est sacré, et que le lendemain vous faites plus ou moins la même chose – si faire cela est humain, si c’est cela qu’il en coûte, alors je suis un être humain après tout. Pleinement, librement, joyeusement, pour la première fois.

Disons-le d’emblée : pas un être humain dénué d’agressivité ou de combativité. Je suis une femme vieillissante et furieuse, ferraillant et triomphant des voyous avec mon sac à main. Néanmoins, je n’y vois – ni qui que ce soit d’ailleurs – rien d’héroïque. C’est juste l’une de ces maudites choses que l’on doit faire pour pouvoir continuer à cueillir de l’avoine sauvage et à raconter des histoires.

C’est l’histoire qui fait la différence. C’est l’histoire qui me cachait mon humanité, l’histoire que racontaient les chasseurs de mammouth à propos de raclée, de viol, de meurtre, à propos du Héros. L’histoire merveilleuse et empoisonnée du Botulisme. L’histoire-qui-tue.

Il semble parfois que cette histoire touche à sa fin. Nous sommes plusieurs à penser, depuis notre coin d’avoine sauvage, au milieu du maïs extra-terrestre, que, plutôt que de renoncer à raconter des histoires, nous ferions mieux de commencer à en raconter une autre, une histoire que les gens pourront peut-être poursuivre lorsque l’ancienne se sera achevée. Peut-être. Le problème, c’est que nous avons tous laissés nos êtres devenir des éléments de l’histoire-qui-tue, et que nous pourrions bien nous éteindre avec elle. C’est donc avec un certain sentiment d’urgence que je cherche la nature, le sujet et les mots de l’autre histoire, celle qui jamais ne fut dites, l’histoire-vivante.

Ce n’est pas dans nos habitudes, ça ne vient pas facilement aux lèvres, inconsciemment, comme le fait l’histoire-qui-tue. Pourtant, dire que cette histoire ne fut jamais dite était exagéré. Des gens ont raconté l’histoire-vivante depuis fort longtemps, avec toutes sortes de mots, de toutes sortes de façons. Mythes de création et de métamorphose, histoires d’esprits filous, contes, blagues, romans, …

Le roman est fondamentalement une forme d’histoire non-héroïque. Bien sûr, le Héros y a souvent pris le pouvoir. C’est la conséquence de son caractère impérial et de ses pulsions incontrôlables : une tendance à tout conquérir et à tout diriger, en édictant dans le même temps des lois et des décrets sévères afin de contrôler son incontrôlable envie de tout tuer. Le Héros a donc décrété, à travers la voix de ses porte-paroles, les Législateurs : premièrement que la forme adéquate du récit est celle de la flèche ou de la lance, partant d’_ici_ et filant tout droit jusque-_là_, et TCHAK ! touchant son but (qui tombe raide mort) ; deuxièmement, que la principale affaire du récit, y compris du roman, c’est le conflit ; et troisièmement, qu’une histoire n’est pas bonne si lui, le Héros, n’en fait pas partie.

Je suis en désaccord avec tout cela. J’irai même jusqu’à dire que la forme naturelle, ajustée, adéquate du roman serait plutôt celle d’un panier, d’un sac. Un livre contient des mots. Les mots contiennent des choses. Ils portent des sens. Un roman est un sac-médecine, contenant des choses prises ensemble dans une relation singulière et puissante.

Une forme possible de cette relation entre les éléments d’un roman peut bien être celle du conflit, mais réduire le récit au conflit est absurde. (J’ai lu un manuel d’écriture créative qui disait : « Une histoire doit être vue comme une bataille », et qui continuait ainsi en parlant de stratégies, d’attaques, de victoires, _etc._) Dans un récit envisagé comme panier/ventre/boîte/maison/sac-médecine, le conflit, la compétition, la tension, la lutte, _etc_., peuvent être considérés comme des éléments nécessaires à un ensemble. Pour autant, on ne peut pas définir cet ensemble comme conflictuel ou harmonieux, puisque son objectif n’est ni la résolution ni la stase, mais la poursuite d’un processus.

C’est clair que le Héros n’a pas l’air très bien dans ce sac, en définitive. Il a besoin d’une scène, d’un piédestal ou d’un pinacle. Mettez-le dans un panier, et il a l’air d’un lapin, d’une patate.

C’est pour cette raison que j’aime les romans : au lieu de héros, ils contiennent des gens.

C’est pourquoi, lorsque j’ai commencé à écrire des romans de science-fiction, je suis arrivé en traînant ce sac merveilleux, lourd et rempli de trucs – mon panier, tout plein de mauviettes et de maladroits, de petites graines de choses plus petites qu’une graine de moutarde, de filets aux tissages emmêlés qui, lorsque l’on prend le temps de les dénouer, révèlent un galet bleu, un chronomètre qui donne imperturbablement l’heure d’un autre monde et un crâne de souris ; tout plein de commencements sans fins, d’initiations, de pertes, de métamorphoses, de traductions, de bien plus de ruses que de conflits, de bien moins de triomphes que de pièges et de désillusions ; tout plein de vaisseaux qui restent coincés, de missions qui échouent et de gens qui ne comprennent pas. J’ai dit qu’il était difficile de faire un récit captivant en racontant comment nous avons arraché les graines d’avoine sauvage de leurs enveloppes, je n’ai pas dit que c’était impossible. Qui a jamais dit qu’il était facile d’écrire un roman ?

Si la science-fiction est la mythologie de la technologie moderne, alors ce mythe est tragique. La « technologie », ou la « science moderne » (j’emploie ces mots selon leur usage habituel, comme une abréviation inquestionnée pour parler des sciences « dures » et de hautes technologies fondées sur la croissance économique continue) est une entreprise héroïque, herculéenne, prométhéenne, et donc ultimement tragique. La fiction qui incarne ce mythe sera, et a déjà été, triomphante (l’Homme conquiert la terre, l’espace, les extra-terrestres, la mort, le futur, etc.) et tragique (l’apocalypse et l’holocauste, aujourd’hui ou demain).

Si, cependant, on évite le mode Techno-Héroïque linéaire et progressif, épousant la flèche (mortelle) du Temps, si on redéfinit la technologie et la science comme le panier culturel primordial plutôt que comme une arme de domination, alors nous aurons, effet secondaire plutôt plaisant, la possibilité d’envisager la science-fiction comme un champ bien moins rigide et étroit, pas nécessairement prométhéen ou apocalyptique, et comme un genre en fait moins mythologique que réaliste.

C’est là un réalisme étrange, mais la réalité est étrange.

Si on l’envisage correctement, la science-fiction, comme toutes les fictions sérieuses quoique drôles, est une tentative pour décrire ce qui est en train de se passer, ce que les gens font et ressentent réellement, comment ils se relient à toutes les autres choses que contient ce grand sac, ce ventre de l’univers, cet utérus des choses qui seront et cette sépulture des choses qui ont été, cette histoire interminable. En son sein, comme dans toute fiction, il y a suffisamment de place pour garder l’Homme à sa place, là où il doit être dans l’ordre des choses ; suffisamment de temps pour cueillir une profusion d’avoine sauvage et aussi pour les semer, pour chanter à la petite Oom, pour écouter la blague de Ool, pour regarder les tritons et pour que l’histoire ne s’arrête pas là. Il y a encore des graines à cueillir et il y a encore de la place dans le sac des étoiles.

---

Ce texte d’Ursula K. Le Guin est extrait d’un recueil intitulé_ Dancing on the edge of the world_, publié aux [Éditions de l’éclat](http://www.lyber-eclat.net/livres/danser-au-bord-du-monde/) dans une traduction d’Hélène Collon.