---
author: Ivan Illich
---

# L’outil et la crise

Les symptômes d’une crise planétaire qui va s’accélérant sont manifestes. On en a de tous côtés cherché le pourquoi. J’avance pour ma part l’explication suivante : la crise s’enracine dans l’échec de l’entreprise moderne, à savoir la substitution de la machine à l’homme. Le grand projet s’est métamorphosé en un implacable procès d’asservissement du producteur et d’intoxication du consommateur.

La relation de l’homme à l’outil est devenue une relation de l’outil à l’homme. Ici il faut savoir reconnaître l’échec. Cela fait une centaine d’années que nous essayons de faire travailler la machine pour l’homme et d’éduquer l’homme à servir la machine. On s’aperçoit maintenant que la machine ne « marche » pas, que l’homme ne saurait se conformer à ses exigences, se faire à vie son serviteur. Durant un siècle, l’humanité s’est livrée à une expérience fondée sur l’hypothèse suivante : l’outil peut remplacer l’esclave. Or il est manifeste qu’employé à de tels desseins, c’est l’outil qui de l’homme fait son esclave. La dictature du prolétariat et la civilisation des loisirs sont deux variantes politiques de la même domination par un outillage industriel en constante expansion. L’échec de cette grande aventure fait conclure à la fausseté de l’hypothèse.

La solution de la crise exige une radicale volte-face : ce n’est qu’en renversant la structure profonde qui règle le rapport de l’homme à l’outil que nous pourrons nous donner des outils justes. L’outil juste répond à trois exigences : il est générateur d’efficience sans dégrader l’autonomie personnelle, il ne suscite ni esclaves ni maîtres, il élargit le rayon d’action personnel. L’homme a besoin d’un outil avec lequel travailler, non d’un outillage qui travaille à sa place. Il a besoin d’une technologie qui tire le meilleur parti de l’énergie et de l’imagination personnelles, non d’une technologie qui l’asservisse et le programme.

Je crois qu’il faut inverser radicalement les institutions industrielles, reconstruire la société de fond en comble. Pour être efficient et rencontrer les besoins humains qu’il détermine aussi, un nouveau système de production doit retrouver la dimension personnelle et communautaire. La personne, la cellule de base conjuguent de façon optimale l’efficacité et l’autonomie : c’est seulement à leur échelle que se déterminera le besoin humain dont la production sociale est réalisable.

Qu’il se déplace ou qu’il demeure, l’homme a besoin d’outils. Il en a besoin pour communiquer avec autrui comme pour se soigner. L’homme qui chemine et prend des simples n’est pas l’homme qui fait du cent sur l’autoroute et prend des antibiotiques. Mais chacun ne peut tout faire par soi et dépend de ce que lui fournit son milieu naturel et culturel. L’outil et donc la fourniture d’objets et de services varient d’une civilisation à l’autre.

L’homme ne se nourrit pas seulement de biens et de services, mais de la liberté de façonner les objets qui l’entourent, de leur donner forme à son goût, de s’en servir avec et pour les autres. Dans les pays riches, les prisonniers disposent souvent de plus de biens et de services que leur propre famille, mais ils n’ont pas voix au chapitre sur la façon dont les choses sont faites, ni droit de regard sur ce qu’on en fait. Dégradés au rang de consommateurs-usagers à l’état pur, ils sont privés de convivialité.

J’entends par convivialité l’inverse de la productivité industrielle. Chacun de nous se définit par relation à autrui et au milieu et par la structure profonde des outils qu’il utilise. Ces outils peuvent se ranger en une série continue avec, aux deux extrêmes, l’outil dominant et l’outil convivial. Le passage de la productivité à la convivialité est le passage de la répétition du manque à la spontanéité du don. La relation industrielle est réflexe conditionné, réponse stéréotypée de l’individu aux messages émis par un autre usager, qu’il ne connaîtra jamais, ou par un milieu artificiel, qu’il ne comprendra jamais. La relation conviviale, toujours neuve, est le fait de personnes qui participent à la création de la vie sociale. Passer de la productivité à la convivialité, c’est substituer à une valeur technique une valeur éthique, à une valeur matérialisée une valeur réalisée. La convivialité est la liberté individuelle réalisée dans la relation de production au sein d’une société dotée d’outils efficaces. Lorsqu’une société, n’importe laquelle, refoule la convivialité en deçà d’un certain niveau, elle devient la proie du manque ; car aucune hypertrophie de la productivité ne parviendra jamais à satisfaire les besoins créés et multipliés à l’envi.

Ivan Illich, « L’outil et la crise », _La convivialité_, chapitre 2, Ed. du Seuil, 2003

<!--  -->
→ Ivan Illich continue ici sa critique de la société industrielle. En même temps il l’amplifie et la radicalise. Il ne vise plus une institution particulière (l’école, la santé, les transports), mais l’organisation globale. Il dénonce la servitude née du mode industriel de production, le gigantisme des outils, le culte de la croissance indéfinie. 
Il s’agit de savoir si l’homme des pays riches (image d’un bonheur fictif sur lequel s’aligne l’espérance des pays pauvres) entend accepter sans murmure l’existence confortable, contrôlée, artificielle, sans responsabilité et sans surprise que lui offre l’institution. 
Ou bien, va-t-il sortir de son sommeil, réclamer son droit, reprendre la parole et en même temps le pouvoir de décider. Imposer des limites à cette glu de produits et de biens qui le submerge, rouvrir un espace social de rencontres et d’échanges, se souvenir qu’il a un passé, des voisins, des égaux. Car la convivialité ne se sépare pas de l’équité. 
Ivan Illich considère ce livre comme un document de travail, un outil avec lequel poursuivre l’analyse, affiner la réflexion. Il veut qu’on tienne ce texte pour inachevé, modifiable par l’expérience à venir. Car la prise de conscience sociale, le réveil politique, l’inversion des institutions ne seront pas l’oeuvre d’un homme seul, ni d’une poignée d’agitateurs. Il faut des hommes lucides qui en prennent le risque, il faut des dormeurs qui s’éveillent et qui parlent. 