---
source: https://wildproject.org/livres/plurivers?noimages
author: Massimo De Angelis
tags: ordinateurs, logiciel, propriété intellectuelle, communs
---

# Communs

Massimo De Angelis

Par « communs », j’entends les systèmes sociaux composés de trois éléments de base interconnectés : 1) un _commonwealth_, c’est-à-dire un ensemble de ressources détenues en commun et régies par 2) une communauté de _commoners_ qui s’engagent également dans 3) la pratique du _commoning_, ou « faire en commun », qui perpétue leur vie en commun et celle de leur _commonwealth_. En ce sens, toutes les formes de coopération humaine non hiérarchique sont des formes différentes de communs. Cette définition est plus générale et plus complète que la définition classique, qui considère les communs simplement comme des ressources partagées par un ensemble d’individus.

La notion de communs a sa propre histoire et ses diverses interprétations. L’historien Peter Linebaugh (2008) situe l’origine de ce mot dans les pratiques paysannes médiévales de collectivisation des terres du roi, une pratique qui a été appelée « _commoning_ ». Avec l’avancée du capitalisme et ses vagues successives d’enclosure des communs, le terme a été de moins en moins utilisé, tandis que le langage politico-théorique a commencé à se concentrer sur d’autres terminologies pour désigner la pratique de l’alter-capitalisme. Cet état de fait a duré jusqu’à ce que les mouvements des années 1960-1970 remettent à l’ordre du jour le communautarisme et le « partage ». C’est précisément au milieu de cette période qu’est apparue la critique moderniste des communs. En 1968, l’écologiste Garrett Hardin a publié un article dans _Science_ sur « la tragédie des communs ». Cet article fondateur affirmait que le partage de la terre ou de toute autre ressource entre un groupe d’agriculteurs entraîne toujours l’épuisement des ressources. Pour le démontrer, Hardin a déployé une théorie de l’individualisme méthodologique qui postule que les différents agriculteurs ne visent qu’à maximiser leur intérêt individuel. Pour atteindre cet objectif, ces derniers permettent à leurs vaches de paître plus longtemps dans le pré ou y font venir plus de vaches. Il est évident que du fait de cette concurrence croissante entre agriculteurs dans le contexte d’une réserve de ressources fixe, cette dernière s’épuisera, d’où la tragédie des communs. La solution proposée par Hardin était double : soit poursuivre la privatisation des communs par différents droits de propriété, soit contrôler et faire appliquer les règles relatives aux communs par l’État.

En 1990, Elinor Ostrom a produit une critique efficace et simple de la thèse de Hardin. Après avoir étudié des milliers de cas différents de communs existant dans le monde entier, dont certains ont survécu des centaines d’années, Ostrom a soutenu que Hardin ne parlait pas de la tragédie des communs, mais de la « tragédie du libre accès ». Ce que la parabole de Hardin ne prend pas en compte, c’est que les communs sont régis par les _commoners_ qui décident collectivement des règles d’accès et les contrôlent en permanence. De fait, les _commoners_ ne s’occupent pas seulement de leurs propres intérêts, mais veillent également à ce que leur interaction collective avec les ressources partagées soit soutenable, faute de quoi ils perdraient tous les ressources dont ils dépendent. Ostrom a ainsi établi un lien clair entre le _commonwealth_ (ou la richesse détenue en commun), une communauté de _commoners_ et leur système de gouvernance.

La définition initiale des communs par Ostrom souffre cependant d’une limitation importante. Dans son approche, les communs apparaissent comme des biens rivaux ou soustractibles, avec un faible degré d’exclusivité. Cela implique que seuls les systèmes de ressources sont des communs – par exemple une zone de pêche, un canal d’irrigation, une nappe phréatique ou une zone de pâturage –, et non les unités de ressources dérivées de ces systèmes, comme « les tonnes de poissons récoltées dans une zone de pêche, les acres-pieds ou les mètres cubes d’eau prélevés d’une nappe phréatique ou d’un canal d’irrigation, les tonnes de fourrage consommées par les animaux dans les zones de pâturage » (Ostrom, 2010 [1990]).

Cette distinction va toutefois à l’encontre de l’expérience historique et de la complexité des formes contemporaines de communs, tels qu’ils sont revendiqués par divers mouvements sociaux dans le monde. En premier lieu, tant du point de vue historique que de l’expérience actuelle, il existe en effet une myriade d’exemples de communautés qui mettent en commun des unités de ressources exclusives dans un « pot commun » – des ludothèques aux cuisines collectives – et qui définissent ensuite des règles ou des usages pour leur appropriation individuelle. Deuxièmement, au cours des dernières décennies, on a constaté un intérêt croissant pour les biens communs non rivaux, tels les communs qui concernent la connaissance, la musique ou les codes sources des logiciels. Comme pour les ressources communes d’Ostrom, il est difficile d’interdire aux gens de profiter de ce type de ressources. De plus, le « stock » de la ressource n’est pas réduit lorsqu’on l’utilise. Au contraire, le véritable problème lié à ces ressources est le fait que le capital impose leur privatisation, ce qui les rend artificiellement rares. Le mouvement en faveur du libre accès est un mouvement qui, avec différentes nuances, est fondé sur le refus de la privatisation de biens non rivaux tels que l’information et la connaissance. Dans le milieu universitaire et le cyberespace, il s’agit d’un mouvement social qui défend les principes du partage de l’information, de l’_open source_, du _copyleft_, des Creative Commons et de la non-privatisation des communs de la connaissance (Benkler, 2003). Tous ces cas renvoient à la définition des communs non seulement comme un type de ressource partagée – ce qui pourrait être n’importe quoi –, mais aussi comme un système social comprenant trois éléments (De Angelis, 2017) : le _commonwealth_ ; une communauté de _commoners_ ; et une pratique du _commoning_, ou de l’action en commun, qui inclut l’acte de régir les relations entre le _commonwealth_ et la nature, et entre les _commoners_ euxmêmes.

Au cours des dernières décennies, nous avons assisté à l’émergence de communautés autochtones et de nouveaux systèmes de communs, qui sont devenus plus visibles et innovants un peu partout : des rues de Cochabamba à celles de New York, Johannesburg, Athènes et Mumbai. Des ressources sont ainsi soustraites au système capitaliste et insérées dans des processus de production collective et des cultures fondées sur des valeurs participatives et démocratiques, avec pour horizon le bien-être des _commoners_ et la soutenabilité environnementale. Cette émergence de l’action collective est d’abord un moteur de survie face aux nombreuses _enclosures_ et crises du néolibéralisme, mais elle manifeste aussi un refus de se soumettre aux technologies néolibérales d’exploitation sur les questions de reproduction sociale telles que l’alimentation, le logement, l’énergie, les soins de santé, l’éducation, les arts et la culture, ou même les « communs mondiaux » de la biosphère. Deuxièmement, cette action collective agit comme une exploration participative innovante des nouvelles technologies et des formes de cybercoopération : production de logiciels _open source_, coopération _peer-to-peer_ comme pour Wikipédia, ou machines _open source_. Ces espaces de coopération multidimensionnels donnent 197l’espoir d’une transformation post-capitaliste, dans la mesure où ils représentent l’émergence de socio-écologies orientées vers un modèle de production qui constitue une alternative au capitalisme et aux systèmes d’État autoritaires. Le danger existe cependant que ces systèmes étatiques soient capables de prendre le contrôle sur les communs de manière à leur faire supporter davantage le coût de la reproduction sociale. Il faut pour cela tisser des liens entre les communs émergents et traditionnels et les mouvements sociaux, pour aboutir à des mouvements de communs qui reconstruisent le tissu de la reproduction sociale et fixent une limite de plus en plus grande à la volonté du capital de croître sans fin.

## Pour aller plus loin

- _The Commoner_, www.thecommoner.org
- Creative Commons, www.creativecommons.org
- The Digital Library of the Commons, www.dlc.dlib.indiana.edu
- Benkler, Yochai (2003), « The Political Economy of Commons », _The European Journal for the Informatics Professional_, vol. 4, no 3, p. 6-9.
- De Angelis, Massimo (2017), Omnia sunt communia: _On the Commons and the Transformation to Postcapitalism_, Londres : Zed Books.
- Hardin, Garrett (1968), « The Tragedy of the Commons », _Science_, vol. 162, no 3859, p. 1243-1248.
- Linebaugh, Peter (2008), _The Magna Carta Manifesto: Liberties and Commons for All_, Berkeley : University of California Press.
- Ostrom, Elinor (2010 [1990]), _Gouvernance des biens communs : pour une nouvelle approche des ressources naturelles_, Louvain-la-Neuve : De Boeck Supérieur.

Massimo De Angelis est professeur d’économie politique à l’université de Londres-Est. En 2000, il a fondé _The Commoner_, une revue en ligne. Il est l’auteur de nombreuses publications sur l’économie politique critique, la mondialisation néolibérale, les mouvements sociaux et les communs, parmi lesquelles _The Beginning of History: Global Capital and Value Struggles_ (Pluto, 2007) et _Omnia sunt communia: On the Commons and the Transformation to Postcapitalism_ (Zed Books, 2017).