---
source: https://www.arretsurimages.net/chroniques/clic-gauche/monopoly
author: Thibault Prévost 
media: Arrêt sur images
---

# Monopoly 

> Alors que les signes de l'éclatement de la bulle financière de l'IA s'amoncellent, le marché continue de dépenser comme jamais. Le signe d'un régime politique et économique délirant, dans lequel une poignée de monopoles s'exonère de la rationalité.

---

La vérité, a un jour écrit l'immense Philip K. Dick, c'est ce qui perdure lorsque l'on cesse d'y croire. Ce sont les faits, têtus et inexpugnables, qui s'installent lorsque la psychose reflue et que l'hallucination se dissipe. Parfois, le retour au réel se fait en douceur. Parfois, seul un choc violent avec le réel peut desserrer l'emprise de l'illusion. Depuis le début de l'été, l'industrie de l'intelligence artificielle et le techno-capitalisme dans son ensemble vivent enfin un début de crise de foi. Après dix-huit mois à empiler les superlatifs jusqu'à l'absurde pour nous convaincre (et s'auto-convaincre) que des générateurs de texte améliorés étaient l'inévitable futur des sociétés, les voilà obligés d'admettre une possibilité encore impensable il y a six mois : l'IA censée révolutionner le monde ne sert en réalité à rien, et la bulle financière qui la soutient s'apprête à éclater. Les indices s'amoncellent, pour peu qu'on se force à regarder au-delà du brouillard médiatique hallucinogène qui entoure la technique depuis les premiers balbutiements de ChatGPT. 

Petit tour d'horizon. En 2023, le fonds d'investissement Sequoia Capital, pas exactement connu pour son agit-prop altermondialiste, écrivait que les "Sept Magnifiques", le surnom énamouré des sept plus grosses valeurs boursières de la tech (Alphabet, Amazon, Apple, Meta, Microsoft, Nvidia, Tesla) devaient répondre à [_"une question à 200 milliards de dollars"_](https://www.sequoiacap.com/article/ais-600b-question/). Une question toute simple : comment comptent-ils gagner de l'argent à court ou moyen terme avec l'IA lorsqu'elle nécessite des investissements gigantesques dans l'infrastructure - _data centers_, cartes graphiques et désormais centrales nucléaires pour alimenter le tout - tout en ne rapportant absolument rien? La seule réponse que l'industrie daigne fournir, [par la voix de ses PDG prophètes](https://www.ft.com/content/b7037ce1-4319-4a4a-8767-0b1373cec9ce) : gardez la foi et laissez-nous faire. Mark Zuckerberg, un patron qui a un jour dépensé 36 milliards de dollars en 18 mois dans un métavers totalement inutile sans être une seconde inquiété par son conseil d'administration, explique par exemple que son prochain modèle d'IA nécessitera _"10 fois plus"_ de puissance de calcul que l'actuel et affirme qu'il faudra _"des années"_ avant que la technique ne soit rentable. Une foi aveugle partagée par Satya Nadella, Sundar Pichai et les autres, patrons de conglomérats devenus techno-prophètes aux poches sans fond, totalement détachés des impératifs de base de l'économie de marché - notamment celui de vendre un produit plus cher que ce qu'il coûte à produire, afin d'en tirer un bénéfice.  

[![La question (à 200 milliards) qui fâche](https://api.arretsurimages.net/api/public/media/la-question-a-200-milliards-qui-fache/action/show?format=public&t=2024-08-22T17:56:33+02:00)](https://api.arretsurimages.net/api/public/media/la-question-a-200-milliards-qui-fache/action/show?format=public&t=2024-08-22T17:56:33+02:00)

### La question (à 200 milliards) qui fâche

Sequoia Capital, 20 septembre 2023  

Alors, en l'espace d'un an, la question à 200 milliards est devenue... une question à 600 milliards, [estimait ce même Sequoia Capital en juin](https://www.sequoiacap.com/article/ais-600b-question/). À ce rythme infernal, l'industrie aura bientôt une question à 1000 milliards de dollars sur les bras, _"sans résultats probants"_ pour y répondre, hallucinait [pour sa part un autre faiseur de pluie du capitalisme, Goldman Sachs, dans un rapport de juin](https://www.goldmansachs.com/insights/top-of-mind/gen-ai-too-much-spend-too-little-benefit). Au seul second trimestre 2024, les dépenses en capital ("capex", en jargon de téléspectateur de BFM Business) d' Alphabet, Apple, Amazon, Meta et Microsoft [ont atteint 59 milliards de dollars](https://www.nytimes.com/2024/08/02/technology/tech-companies-ai-spending.html), et plus de 106 milliards au premier semestre 2024. Du délire. Selon le média _The Information_, OpenAI, "leader" du marché (inexistant) de l'IA générative,  [pourrait perdre 5 milliards de dollars en 2024](https://www.theinformation.com/articles/why-openai-could-lose-5-billion-this-year) - dix fois plus qu'en 2022. Réaction de son PDG Sam Altman, [interrogé en mai](https://fortune.com/2024/05/03/openai-sam-altman-microsoft-agi-artificial-general-intelligence-costs/) sur l'inanité de son _business model_ : _"Cramer 500 millions ou 5 milliards de dollars par an, je m'en fous - vraiment, je m'en fous."_  Altman le dit et le répète, il est au-dessus des basses motivations pécuniaires. Son truc à lui, c'est d'atteindre la "singularité technologique" et de l'offrir à toute l'humanité. Le fait que sa philanthropie ait fait de lui [un milliardaire en avril dernier](https://www.forbes.com/sites/alexkonrad/2024/04/08/openai-made-sam-altman-famous-his-investments-made-him-a-billionaire/) relève de la coïncidence.  

Conséquence logique d'une caste de patrons qui a visiblement [décidé de laisser le bon sens économique au vestiaire](https://www.theatlantic.com/technology/archive/2024/07/ai-companies-unprofitable/679278/), un seul réel gagnant se détache de cette hallucination collective : Nvidia, qui fabrique et vend les cartes graphiques sur lesquelles fonctionnent les machines à désinformation vendues par la clique de camelots californiens. Mais là encore, quelque chose cloche. L'entreprise vaut désormais 3000 milliards de dollars en Bourse - soit 500 millions de dollars de plus que _l'intégralité du CAC 40_ \- et talonne Apple pour la position d'entreprise la plus chère du monde. Pendant la ruée vers l'or, il fait bon être vendeur de pioches.  

[![IA générative : trop de dépenses, pas assez de bénéfices?](https://api.arretsurimages.net/api/public/media/ia-trop-de-depenses-pas-assez-de-benefices/action/show?format=public&t=2024-08-22T18:00:53+02:00)](https://api.arretsurimages.net/api/public/media/ia-trop-de-depenses-pas-assez-de-benefices/action/show?format=public&t=2024-08-22T18:00:53+02:00)

### IA générative : trop de dépenses, pas assez de bénéfices?

Goldman Sachs, 27 juin 2024  

Les chiffres donnent le tournis. L'IA générative est le _vaporware_ le plus cher, le plus inutile et le plus polluant de l'histoire des gadgets inutiles. Ce n'est pas moi qui le dis. Même chez les gardiens du temple sociopathes du capitalisme spéculatif, pourtant habitués à s'enrichir en prédateur sur des conditions macroéconomiques absurdes, l'industrie de l'IA générative [passe pour](https://www.bloomberg.com/news/articles/2024-08-02/big-tech-fails-to-convince-wall-street-that-ai-is-paying-off?srnd=phx-ai&ref=wheresyoured.at) une secte millénariste. Dans [un courrier supposément confidentiel](https://www.ft.com/content/24a12be1-a973-4efe-ab4f-b981aee0cd0b) envoyé à ses clients début août, le fonds spéculatif Elliott Management conseille à ses clients de prendre ses distances avec les entreprises de l'IA, qu'il décrit comme une technique _"surévaluée dont la plupart des applications ne sont pas prêtes"_, qui ne sera _"jamais économique, ne fonctionnera jamais correctement, consommera trop d'énergie et restera perpétuellement faillible"_. Ippon. Chez Goldman Sachs, [le ton se fait presque menaçant](https://www.goldmansachs.com/insights/top-of-mind/gen-ai-too-much-spend-too-little-benefit) : _"Plus le temps passe sans usages significatifs, plus le récit de l'intelligence artificielle deviendra difficile à tenir. Si aucun cas d'usage important n'apparaît dans les 12 à 18 prochains mois, l'enthousiasme des investisseurs va peut-être se dissiper."_ Même le cabinet McKinsey, qui [promettait en juin 2023](https://www.mckinsey.com/capabilities/mckinsey-digital/our-insights/the-economic-potential-of-generative-ai-the-next-productivity-frontier#key-insights) que ChatGPT et les autres allaient bientôt produire l'équivalent du PIB annuel du Royaume-Uni (il faut se rendre compte du degré d'insanité) a cessé les bouffées délirantes, et suggère désormais de _["regarder au-delà de la hype"](https://www.mckinsey.com/industries/technology-media-and-telecommunications/our-insights/beyond-the-hype-capturing-the-potential-of-ai-and-gen-ai-in-tmt)_. En plissant les yeux et en priant pour qu'un modèle économique rentable se matérialise à l'horizon ? Raté. Parce qu'au-delà de la _hype_, il n'y a rien.  

[![Même Bloomberg commence doucement à comprendre](https://api.arretsurimages.net/api/public/media/meme-bloomberg-commence-doucement-a-comprendre/action/show?format=public&t=2024-08-22T18:04:34+02:00)](https://api.arretsurimages.net/api/public/media/meme-bloomberg-commence-doucement-a-comprendre/action/show?format=public&t=2024-08-22T18:04:34+02:00)

### Même Bloomberg commence doucement à comprendre

Bloomberg, 2 août 2024  

Dans la presse aussi, le discours a changé. Oubliés le messianisme et les prophéties techno-apocalyptiques de l'été dernier, quand grands patrons de la Silicon Valley, "parrains de l'IA" et experts autoproclamés promettaient alternativement transcendance et extinction de l'humanité à des journalistes en état de sidération. Depuis un an, la nullité constante de l'IA générative dans toutes les industries où elle a été implémentée a fracassé un à un les discours publicitaires contre le mur du réel. Dernier fiasco en date, celui d'une campagne présidentielle étasunienne "alimentée par IA", [nous informe le _New York Times_](https://www.nytimes.com/2024/08/21/technology/ai-election-campaigns.html). Dans le monde réel, personne n'a envie de parler politique avec un _chatbot_, qu'il bosse pour le camp démocrate ou républicain. 

Alors, depuis le décrochage boursier du Nasdaq fin juillet, conséquence de la publication des (mauvais) résultats des conglomérats de la tech, on s'autorise enfin [à poser la question de la bulle financière](https://www.lesechos.fr/finance-marches/marches-financiers/lia-est-elle-une-bulle-speculative-2112076). Les comparaisons se multiplient avec la bulle dot-com de l'an 2 000, qui a vu le Nasdaq perdre 70% de sa valeur après des années de survalorisation de jeunes entreprises du Web. Sur Google, les recherches du terme _"bulle de l'IA"_ n'ont jamais été aussi nombreuses, reflet d'un _zeitgeist_ médiatique et économique qui voit enfin l'industrie de la tech dans sa glorieuse absurdité. Car pendant que Zuckerberg, Nadella, Pichai, Altman et les autres brûlent des dizaines de milliards de dollars en riant, le nombre de faillites de start-ups [a augmenté de 60% aux Etats-Unis l'année dernière](https://www.ft.com/content/2808ad4c-783f-4475-bcda-bddc0299095e). Ce n'est plus de la concentration de capital, c'est un siphonnage en règle. Tout le capital-risque disponible va directement dans la fournaise de l'IA générative.  

[![Evolution des recherches "AI bubble" depuis cinq ans](https://api.arretsurimages.net/api/public/media/evolution-des-recherches-ai-bubble-depuis-cinq-ans/action/show?format=public&t=2024-08-22T14:16:26+02:00)](https://api.arretsurimages.net/api/public/media/evolution-des-recherches-ai-bubble-depuis-cinq-ans/action/show?format=public&t=2024-08-22T14:16:26+02:00)

### Evolution des recherches "AI bubble" depuis cinq ans

Google Trends, 22 août 2024  

Il ne faut pas avoir un doctorat en économie pour comprendre que ce que nous vivons est absurde. Une entreprise fonctionnelle et saine n'investit pas des dizaines de milliards en pure perte dans un produit qui ne sert à rien et dont personne ne veut. Certes, dans la Silicon Valley, le profit a depuis longtemps cessé d'être un indicateur de succès - rappelez-vous d'Amazon, qui a mis 14 ans à générer du profit, ou d'Uber, qui a mis 15 ans à y parvenir (et encore, en manipulant ses chiffres). Certes, le capitalisme de start-up des quinze dernières années n'était rien d'autre qu'un programme de subventions généralisé, permis par des fonds d'investissements de Wall Street aux poches sans fond et une politique monétaire de taux d'intérêts nuls, qui a plus ou moins pris fin en 2022 lorsque la réserve fédérale étasunienne a décidé la fin de la gratuité de l'argent. Certes, nous vivons un moment d'emmerdification généralisée de la tech, où le profit laisse progressivement place à la rente et la qualité des produits commercialisés n'entre plus en ligne de compte. On le sait, mais ce qui se joue autour de l'IA générative est autrement plus grave. Car non seulement la bulle n'a pas encore explosé, mais le Nasdaq et Nvidia [sont repartis à la hausse](https://qz.com/nvidia-stock-nvda-rally-nasdaq-mag-seven-1851627565) ces derniers jours, toujours plus loin dans l'aberrant. Des dizaines de milliards de dollars partent en fumée chaque mois et les investisseurs, comme sous emprise sectaire, continuent de mettre la main au portefeuille contre la promesse de l'au-delà technologique.  

Pour reprendre [l'excellent technocritique Edward Zitron,](https://www.wheresyoured.at/burst-damage/) effaré par cet étalage d'insensé et probablement dans un état de frustration terrible, ce que raconte cette bulle, c'est l'histoire d'une poignée d'entreprises - Meta, Amazon, Microsoft, Alphabet et Apple, dans une moindre mesure - en train de pourrir de l'intérieur, en pénurie d'idées, désespérément en quête d'un marché à hypercroissance à dominer et maintenant pris [au piège des coûts irrécupérables](https://theconversation.com/what-is-the-sunk-cost-fallacy-is-it-ever-a-good-thing-217798) \-en économie comportementale, le biais cognitif qui nous pousse à nous entêter dans un comportement irrationnel au nom de l'investissement déjà consenti. L'IA générative n'est ni le prochain iPhone, ni le prochain réseau social, ni le prochain changement de paradigme sociotechnique. Elle est la manifestation de l'imaginaire frelaté d'une poignée de charlatans démiurges, déconnectés du corps social aussi bien idéologiquement que géographiquement, qui tentent de nous vendre des machines à brasser du vide après avoir échoué à écouler des casques de VR pourris, une "monnaie" virtuelle qui n'achète rien et des fichiers JPEG de singes, en affirmant à chaque tentative que leur camelote annonçait une nouvelle étape de la civilisation. Il n'y a pas de grand plan, de surprise du chef, d'arme secrète développée dans des labos de R&D d'OpenAI et consorts qui s'apprête à révolutionner le monde - il n'y a même pas de GPT-5 à l'horizon ! Ce qui se joue en ce moment n'est pas une partie d'échecs en 5D jouée par des entrepreneurs de génie pour prendre le contrôle du futur. Comme la bulle crypto de 2022, c'est une partie de Monopoly entre monopoles, qui se foutent complètement de ce qui adviendra au-delà du plateau de jeu, improvisent au jour le jour et se justifient ensuite.  

Ce que nous raconte enfin ce moment économique absurde, c'est la culmination d'un processus de féodalisation économique enclenché par cinq ou six multinationales pour vassaliser le reste de l'économie. Le technocapitalisme, parodie de libre-échange, pourrit aux mains d'un cartel protégé aussi bien de la concurrence que de la régulation, libre de fixer les règles qui déterminent son propre enrichissement. Son objectif n'est donc plus de produire, mais de devenir l'infrastructure qui soutient le monde. Quitte à [massacrer le vivant au passage](https://www.arretsurimages.net/chroniques/clic-gauche/le-data-center-va-manger-le-monde) et à maquiller sa toxicité à coups d'[achat de crédits carbone au prix de gros.](https://www.ft.com/content/2d6fc319-2165-42fb-8de1-0edf1d765be3) Mais tout le _greenwashing_ du monde ne suffira pas à dissimuler l'intolérable évidence : l'IA générative est non seulement un écocide, mais un écocide pour rien. [Dans une mise à jour inédite du capitalocène](https://www.lemonde.fr/idees/article/2024/07/10/l-ecologie-monde-du-capitalisme-comprendre-et-combattre-la-crise-environnementale-vers-un-ecomarxisme-du-vivant_6248310_3232.html), les géants de la tech sont en train d'échanger le vivant contre une machine à générer des lettres de motivation, des dépenses... et aucun profit. De l'extraction et de la destruction pure, qui ne s'embarrasse même plus des apparences de l'utilité commune. [Un trou noir environnemental qui grossit et grossit](https://www.arretsurimages.net/chroniques/clic-gauche/le-data-center-va-manger-le-monde), dont la croissance devrait être stoppée par tous les moyens adéquats et les architectes traduits devant la justice.  

[![Comment Big Tech redéfinit la neutralité carbone à son avantage](https://api.arretsurimages.net/api/public/media/coimment-big-tech-redefinit-la-neutralite-carbone/action/show?format=public&t=2024-08-22T18:18:31+02:00)](https://api.arretsurimages.net/api/public/media/coimment-big-tech-redefinit-la-neutralite-carbone/action/show?format=public&t=2024-08-22T18:18:31+02:00)

### Comment Big Tech redéfinit la neutralité carbone à son avantage  

Financial Times, 14 août 2024  

Cette [partie de Monopoly](https://www.wheresyoured.at/monopoly-money/) entre multimilliardaires pyromanes doit donc cesser, et il n'y a pas trente-six solutions : il faut les briser, comme [la loi a brisé les _"barons voleurs"_](https://www.history.com/news/robber-barons-gilded-age-wealth) du capitalisme industriel des années 20, alors aussi obscènes qu'un Elon Musk ou un Mark Zuckerberg, nouveaux visages de [cette _"société de provocation"_](https://luxediteur.com/catalogue/la-societe-de-provocation/) ultrariche décrite par la sociologue Dahlia Namlian. L'espoir est infime, mais il existe. Le 7 août, le Département de la Justice étasunien a condamné Google pour pratique anticoncurrentielle sur son moteur de recherche, ce qui referme une période de 25 ans d'impunité pour le secteur étasunien de la tech. La procédure doit ouvrir la voie à des poursuites similaires contre Meta, Amazon et Apple. Tous sont champions de ce que Zitron appelle [_"l'économie du pourrissement"_](https://www.wheresyoured.at/rotcombubble/), cette idéologie de l'expansion à tout prix qui ne s'embarrasse plus de concevoir des produits et services vaguement utiles au corps social et se contente de se rendre _incontournable_ pour mieux gouverner en cartel_._ La Silicon Valley pourrit sur place, idéologiquement et stratégiquement, sous un feu d'artifice de dollars. Plus ses services sont mauvais, moins on peut y échapper.  

Ainsi va Big Tech, en monopole ou duopole. Le cloud, c'est Microsoft et Amazon. La publicité en ligne, c'est Google et Meta. La recherche, c'est Google. Le commerce en ligne, Amazon. Le PC, Microsoft. Les applis mobiles : Apple, qui extorque une taxe exorbitante de 30% à tous les développeurs... excepté quelques privilégiés. Et le petit nouveau, Nvidia, déjà scruté par le Département de la Justice, truste le marché de la carte graphique.  Et ainsi de suite, dans [ce que Cory Doctorow baptise le _"capitalisme d'étranglement"_](https://doctorow.medium.com/the-super-rich-got-that-way-through-monopolies-c4fd28ef69d6) (_chokepoint capitalism_), devenu le système d'exploitation préférentiel d'une économie illibérale. Le seul [avantage de cette hyper-concentration du capital](https://doctorow.medium.com/https-pluralistic-net-2024-04-10-an-injury-to-one-is-an-injury-to-all-eb00c142aec3), c'est qu'elle réduit le nombre d'ennemis à abattre et la diversité des tactiques à utiliser. Peu importe son secteur, un monopole est un monopole. On ne négocie pas avec, on le brise. Sans offensive de régulation, le devenir de la bulle financière de l'IA importe peu. Peu importe le scénario, les souverains arnaqueurs de la tech survivront à l'éclatement de leur délire, trébucheront sur les cadavres des victimes et reprendront leur lente marche de zombie [vers la singularité capitaliste](https://doctorow.medium.com/monopolys-event-horizon-23c051ab604b). Pour Amazon, Meta, Alphabet et Microsoft, ce sera une semaine comme une autre, quelques centaines de millions de dollars perdus jusqu'à la prochaine révolution bullshit. Pourquoi ? Car hype après hype, bulle après bulle, milliards après milliards, le cartel de la tech _nous confisque la possibilité de penser l'avenir._ Elle est là, la conséquence la plus terrifiante du monopole - un monde sans alternative à leur nullité.  

[![Dans la "bulle de l'économie du pourrissement" ](https://api.arretsurimages.net/api/public/media/la-bulle-de-leconomie-du-pourrissement-approche/action/show?format=public&t=2024-08-22T18:19:38+02:00)](https://api.arretsurimages.net/api/public/media/la-bulle-de-leconomie-du-pourrissement-approche/action/show?format=public&t=2024-08-22T18:19:38+02:00)

### Dans la "bulle de l'économie du pourrissement"  

Edward Zitron, 3 juin 2024
