---
source: https://www.arretsurimages.net/chroniques/clic-gauche/aux-apatrides-du-web-merdique
author: Thibault Prévost
media:  Arrêt sur images
---

# Aux apatrides du web merdique 

> Quinze ans après sa naissance, le Web 2.0, celui des réseaux sociaux, des applis et de la disruption, est en train d'agoniser, sans qu'on sache encore réellement ce qui lui succédera. En cause : l'emmerdification, ou la lente dégradation du capitalisme de plateforme.

---
Ça y est, c'est la fin. Le web ferme boutique. Enfin, pas n'importe quel web, certes – le web social, celui qui domine l'écosystème de l'information depuis 2010. Vous n'êtes pas au courant ? Pourtant, les épitaphes se multiplient dans la presse tech (_nocritique_) depuis quelques mois, autant aux États-Unis que sur nos terres hexagonales. Petit florilège. Le 30 décembre, _Wired_ décrivait 2023 comme _["l'année où l'Internet millennial est mort"](https://www.wired.com/story/end-of-the-millennial-internet/)_. En octobre, le _New Yorker_ nous expliquait, en se rappelant du bon vieux temps, pourquoi _["Internet a cessé d'être fun"](https://www.newyorker.com/culture/infinite-scroll/why-the-internet-isnt-fun-anymore) (spoiler alert_ : l'article décrit essentiellement le destin des réseaux sociaux, ce qui n'a pas grand chose à voir avec "Internet"). En avril, Ellis Hamburger promettait, après sept ans passés chez Snapchat, que _["les réseaux sociaux sont destinés à mourir"](https://www.theverge.com/2023/4/18/23672769/social-media-inevitable-death-monetization-growth-hacks)_. Même son de cloche [chez l'éditorialiste Ed Zitron](https://wheresyoured.at/p/social-media-is-dying), qui affirmait en février que _"les réseaux sociaux sont en train de mourir"_, tandis que la _LA Times_ balançait la même prophétie [en août](https://www.latimes.com/business/technology/story/2023-08-07/column-its-the-end-of-social-media-as-we-know-it-we-should-feel-fine). Gradation finale dans l'oracle, certains médias, comme _[Business Insider](https://www.businessinsider.com/social-media-dead-instagram-tiktok-bereal-replaced-group-chats-messaging-2023-8)_ ou [_Vice_,](https://www.vice.com/en/article/pkgv79/social-media-is-dead) affirment au présent que les _"réseaux sociaux sont morts"_, et qu'ils auraient entraîné avec eux leur cohorte maudite d'influenceurs, de marketeux et de monétiseurs d'attention. (Cherchez _"social media is dead"_ sur Google, et vous comprendrez l'ampleur de l'angoisse qui étreint la classe disruptrice des années 2010.) Même le réputé technocritique Ian Bogost [se muait en prophète dans _The Atlantic_](https://www.theatlantic.com/technology/archive/2022/11/twitter-facebook-social-media-decline/672074/) dès 2022 : _"L'ère des réseaux sociaux touche à sa fin – et elle n'aurait jamais dû commencer."_

[![Pourquoi Internet a cessé d'être fun](https://api.arretsurimages.net/api/public/media/pourquoi-internet-a-cesse-detre-fun/action/show?format=public&t=2024-01-25T17:54:30+01:00)](https://api.arretsurimages.net/api/public/media/pourquoi-internet-a-cesse-detre-fun/action/show?format=public&t=2024-01-25T17:54:30+01:00)

### Pourquoi Internet a cessé d'être fun

The New Yorker, 9 octobre 2023  

Il faut se rendre compte de l'énormité du virage idéologique pris par une partie de la presse spécialisée. Pendant plus d'une décennie, la croissance et la consolidation des oligopoles du Web a semblé si inexorable, si effroyable, si totale, qu'envisager les scénarios de leur chute relevait du blasphématoire ou du délirant. Une pandémie plus tard, des journalistes tech dansent  joyeusement sur les cadavres des titans supranationaux de la décennie 2010, comme si c'était la chose la plus inéluctable qui soit. Est-ce réellement le cas, ou assiste-t-on simplement à la vague de nostalgie d'une génération d'ex-jeunes journalistes nés dans le web des blogs, venus au métier avec le web social et devenus progressivement des trentenaires déconcertés par les usages numériques de la génération suivante ? Y aurait-il un peu des deux? Si le web _millennial_ est mort, penchons-nous au moins sur le cadavre pour une petite séance d'autopsie.

Ce sentiment de déliquescence part d'un constat simple : plus le temps passe, plus le web social, né autour de l'an de grâce 2005, devient merdique. J'écris "merdique" à dessein : l'emmerdification (_enshittification_) du Web est un concept, [formulé en version _beta_ fin 2022](https://doctorow.medium.com/social-quitting-1ce85b67b456) par l'infatigable technocritique Cory Doctorow, qui n'a depuis cessé de le polir. Dans sa version la plus concise, [datée de janvier 2023](https://www.wired.com/story/tiktok-platforms-cory-doctorow/), le principe d'emmerdification postule que _"premièrement, \[les plateformes\] séduisent leurs utilisateurs ; ensuite, elles les exploitent au profit de leurs clients ; pour finir, elles exploitent leurs clients pour récupérer toute la valeur produite. Enfin, elles meurent."_ La puissance de l'analyse de Doctorow réside dans l'idée que la détérioration des services offerts par le capitalisme de plateforme n'est pas circonstancielle mais structurelle, inhérente au modèle lui-même, qui n'a jamais été conçu pour durer mais pour capter un maximum de valeur en un minimum de temps quitte à tout détruire sur son passage _– "Move fast and break things"_.

[![L'emmerdification de Tiktok (et du web social)](https://api.arretsurimages.net/api/public/media/lemmerdification-de-tiktok-et-du-web-social/action/show?format=public&t=2024-01-25T17:56:09+01:00)](https://api.arretsurimages.net/api/public/media/lemmerdification-de-tiktok-et-du-web-social/action/show?format=public&t=2024-01-25T17:56:09+01:00)

### L'emmerdification de Tiktok (et du web social)

Wired, 23 janvier 2023  

Pour détrôner MySpace, Facebook a d'abord cherché à nous montrer ce qui nous plaisait, tout en facilitant au maximum le transfert d'utilisateurs vers sa plateforme. L'effet de réseau, selon lequel un système gagne en valeur à mesure que son nombre d'utilisateurs augmente, a joué à fond. Les gens rejoignaient Facebook parce que leurs proches étaient sur Facebook, ce qui encourageait d'autres gens à rejoindre Facebook. Une fois une masse critique atteinte et sa position dominante assurée, la plateforme s'est transformée en un jardin emmuré, emprisonnant ses utilisateurs dans un enclos panoptique où chacun de leurs posts était surveillé, analysé et exploité au profit des annonceurs. Petit à petit, le site est devenu hostile, ennuyeux et globalement invivable. La même chose se produit sur les autres plateformes. Les disrupteurs frénétiques de 2005, pleins de fonctionnalités et d'usages inédits, sont devenus les monopoles ronronnants de 2020, où nous tournons sans but dans des aquariums informationnels saumâtres.

Et pourtant, nous restons, parce que le coût de transfert (_switching cost_) social, technique et psychologique vers une autre plateforme était trop important – combien d'entre vous ont laissé leur compte Facebook en friche mais utilisent toujours Messenger pour communiquer avec leurs amis, par simple habitude ? Cette notion est absolument centrale dans la stratégie de croissance des plateformes, car qui dit coût de transfert élevé dit monopole, et dit captation maximale des profits. Facebook et les autres plateformes, [explique ce même Cory Doctorow](https://www.eff.org/fr/deeplinks/2021/08/facebooks-secret-war-switching-costs), font donc tout leur possible pour garder ce coût aussi élevé que possible, car _"l'effet de réseau permet de gagner des utilisateurs, et le coût de transfert les prend en otage."_ C'est pour cette raison que les produits Apple sont irréparables, et qu'aucune des plateformes ne facilite l'inter-opérabilité. C'est pour cette raison qu'en 2024, le web n'est pas un outil de libération et de partage mais d'emprisonnement et de captation. Et le cancer du modèle des plateformes – surveillance, extraction, emprisonnement – s'étend doucement au moindre objet disposant d'un circuit électronique. 

L'emmerdification du capitalisme de plateforme n'est pas un accident, encore moins une évolution naturelle de l'écosystème numérique : elle est le résultat d'une idéologie mortifère et d'une série de choix stratégiques délibérés, effectués en toute connaissance des enjeux, et contre les intérêts du plus grand nombre. Comme j'ai pu le lire au détour d'une newsletter, _["le principe de base du capitalisme est l'emmerdification généralisée du monde"](https://pereduchesne.substack.com/p/admettons-le-tout-devient-de-la-merde)_. Puisque nous vivons désormais sous le régime du merdique éphémère, rien d'étonnant à ce que les infrastructures numériques contemporaines reflètent cette hégémonie politique.  

Aujourd'hui, où en sommes-nous de l'emmerdification générale ? Au stade terminal. Facebook, toute honte bue, vous propose de payer dix balles par mois pour respecter votre droit fondamental à la vie privée, après vous avoir consciencieusement transformé en matière première. Chez Twitter c'est 8 euros, sur Spotify c'est 10, sur Youtube c'est 13 et chez Netflix, inflation oblige, c'est passé à 13,50. Sortez les CB, l'ère de la gratuité est terminée. [La télé câblée est de retour](https://www.theverge.com/2024/1/23/24047817/netflix-is-turning-into-cable-tv). Zuckerberg, encore lui, vient de passer deux ans à nous persuader, sans succès, qu'enfiler pendant des heures des casques de VR [qui foutent la gerbe](https://www.theverge.com/23663451/vr-meta-quest-pro-aftercare) pour s'incarner en avatars sans jambes dans des déserts pixellisés [était la prochaine étape de la transcendance humaine](https://www.arretsurimages.net/chroniques/clic-gauche/metaverse-le-paradis-artificiel-selon-saint-zuck). Sa dernière trouvaille : répondre à la fuite des utilisateurs humains – car, enfin, nous n'avons plus assez eu à perdre – en peuplant ses plateformes de PNJ foireux dopés à l'IA.  

Twitter, devenu X depuis qu'il est dirigé [par un adulescent d'extrême-droite](https://www.arretsurimages.net/chroniques/clic-gauche/elon-musk-ne-vous-veut-toujours-pas-du-bien), a [tellement salopé l'information](https://www.theverge.com/c/features/23993135/twitter-breaking-news-history) que le concept de réalité consensuelle nous semble désormais utopique. L'outil anti-censure du _citizen journalism_, des Printemps arabes et de Black Lives Matter, est devenu un bouillon de culture radioactif où batifolent cryptobots, actrices de _soft porn_ et propagandistes fafoïdes venues de tout l'Occident suprémaciste et masculiniste. Dans le supermarché du _dropshipping_ qu'est devenu Instagram, des automates influenceurs vendent sans relâche des produits contrefaits à des armées de bots. Google News [est plein d'articles générés par IA](https://www.404media.co/google-news-is-boosting-garbage-ai-generated-articles/), et ce ne serait que le début du processus de _generative inbreeding_ _–_ les logiciels d'IA entraînés sur du contenu générés par d'autres IA –, qui devrait aboutir à [la destruction totale de la culture humaine](https://venturebeat.com/ai/generative-inbreeding-and-its-risk-to-human-culture/). Même un truc aussi fondamental que le moteur de recherche Google s'est dégradé, irrémédiablement infecté par du contenu publicitaire, [avertissait récemment _404 Media._](https://www.404media.co/google-search-really-has-gotten-worse-researchers-find/)

En 2024, le web social tout entier n'est qu'un satellite de TikTok, ce trou noir supermassif au centre de la galaxie du réel. Le _text-based Internet_ est devenu l'empire du _sludge content_, des vidéos de pure stimulation audiovisuelle [conçues sur-mesure pour le business de l'attention](https://www.ladn.eu/media-mutants/videos-sludge-content-tiktok/). La chambre d'écho algorithmique, cette machine à radicaliser qui devait détruire les démocraties _circa_ 2015, a laissé place à une algorithmie de tous les possibles, qui isole chaque individu dans son infini individuel. La viralité, cette machine à célébrité numérique instantanée capable de construire et de démolir des vies humaines, s'est arrêtée. Le web n'a jamais été aussi riche, aussi peuplé et aussi inaccessible. Vous n'avez jamais vu les vidéos les plus visionnées de TikTok. Vous ne connaissez pas la série la plus vue de Netflix. Le web s'évapore _–_ oui, [le _vapor web_ est déjà un concept journalistique déposé](https://www.garbageday.email/p/is-the-web-actually-evaporating) – comme une bibliothèque infinie de Borges, sans index pour s'y repérer.  

Ne nous resteraient alors que deux choix : _doomscroller_ sur les plateformes traditionnelles pour revoir passer les mêmes vidéos recyclées de TikTok jusqu'à l'effondrement total de notre autonomie cognitive, ou se planquer dans les interstices conversationnels du _dark social_ (Whatsapp, Telegram, Discord, etc), où chaque petit groupe pourra tranquillement construire sa propre réalité synthétique sur-mesure, étanche et balkanisée, au chaud derrière des murs capitonnés. _Safe._ Il y a un concept pour ça : [le web de la forêt noire](https://freedium.cfd/https://onezero.medium.com/the-dark-forest-theory-of-the-internet-7dc3e68a7cb1) (_dark forest web_), où chaque communauté fait tout pour rester dans son entre-soi, invisible aux autres. La migration vers ce _private networking_ a déjà commencé : nous, les gens normaux, ni influenceureuses, ni créateurices, ni robots, [postons déjà moins de contenu que l'année passée](https://www.wsj.com/tech/personal-tech/social-media-nobody-posting-f6c2fd3e).  

[![L'Internet de la forêt noire : pour scroller heureux, scrollons cachés](https://api.arretsurimages.net/api/public/media/linternet-de-la-foret-noire-pour-scroller-heureux-scrollons-caches/action/show?format=public&t=2024-01-25T17:59:27+01:00)](https://api.arretsurimages.net/api/public/media/linternet-de-la-foret-noire-pour-scroller-heureux-scrollons-caches/action/show?format=public&t=2024-01-25T17:59:27+01:00)

### L'Internet de la forêt noire : pour scroller heureux, scrollons cachés

Yancey Strickler, Medium, 20 mai 2019  

L'emmerdification ne se limite évidemment pas aux réseaux sociaux ; elle s'étend à toute l'économie des plateformes. Pas étonnant que le concept ait été élu "mot de l'année 2023" [par la maison d'édition indépendante Verso Books](https://www.versobooks.com/en-gb/blogs/news/enshittification-the-2023-word-of-the-year), tant il incarne le _zeitgeist_ tech des 12 mois écoulés. Voire de toute la décennie passée. Nous vivons indéniablement la fin d'une époque. La fin d'un mirage économique débuté en 2008, au sortir de la crise mondiale des _subprimes_, et qui connaît donc son crépuscule [dans un contexte de "polycrise"](https://www.lemonde.fr/idees/article/2024/01/22/edgar-morin-face-a-la-polycrise-que-traverse-l-humanite-la-premiere-resistance-est-celle-de-l-esprit_6212226_3232.html) – un concept inventé par Edgar Morin en 1999 qui tente de saisir l'intersection des crises géopolitiques, économiques, politiques et climatiques. Une décennie marquée, post-_subprime_s, par une politique de taux d'intérêts historiquement bas (de 2008 à 2015, le taux d'emprunt de la Fed étasunienne [avait été réduit à... zéro](https://www.forbes.com/advisor/investing/fed-funds-rate-history/)), qui voyait l’État étasunien subventionner les investisseurs afin de relancer l'activité.  

[![En 2024, Edgar Morin défend plus que jamais la "polycrise"](https://api.arretsurimages.net/api/public/media/en-2024-edgar-morin-defend-plus-que-jamais-la-polycrise/action/show?format=public&t=2024-01-25T18:01:25+01:00)](https://api.arretsurimages.net/api/public/media/en-2024-edgar-morin-defend-plus-que-jamais-la-polycrise/action/show?format=public&t=2024-01-25T18:01:25+01:00)

### En 2024, Edgar Morin défend plus que jamais la "polycrise"

Le Monde, 22 janvier 2024  

L'économie politique du _blitzscaling_, des Uber et des Airbnb quasi-gratuits, des palaces de la débauche WeWork loués pour trois fois rien, des cimetières de vélos en _free floating_, des trottinettes électriques à 1 euro le trajet, des licornes surévaluées, des livraisons de bouffe en 15 minutes et des arnaques à la Juicero (l'extracteur de jus connecté qui ne servait à rien, mais levait 120 millions de dollars en 2014) restera probablement dans l'histoire des sociétés comme un court épisode de délire collectif symptomatique du capitalisme tardif. Mais les conséquences de la bulle web 2.0, qui a quand même réussi à marcher pendant 15 ans au mépris des lois élémentaires de l'économie de marché, sont profondes. Cette bouffée délirante a défini le quotidien de toute une génération – la mienne, celle des _millennials_, simultanément paupérisée par la violence néolibérale post-2008 et subventionnée au quotidien par une génération de start-ups étasunienne brûlant des montagnes de dollars en pleine épiphanie messianique (pour vous donner une idée de l'ambiance, [jetez un oeil à la mini-série _WeCrashed_](https://www.youtube.com/watch?v=UREIAoL0Spk)). Une culture sociotechnique tout entière s'est développée sur des conditions macroéconomiques aberrantes et des oracles financiers dignes d'une secte millénariste.  

Ce qui nous a échappé, en apesanteur dans [_nos AirSpace_ minimalistes à ampoules Edison et fausses briques apparentes](https://www.vox.com/the-goods/2018/12/27/18156431/recession-fashion-design-minimalism), c'est que notre _millennial lifestyle_ de jeune adulte posait simultanément les bases du nouveau contrat social néolibéral : partout où ce serait possible, une start-up à but lucratif remplacerait un service public, puisque ça fonctionnait si bien. On appellerait ça l'ubérisation. Le succès d'Uber, écrivent les auteurs de [_Disrupting D.C.: The Rise of Uber and the Fall of the City_](https://press.princeton.edu/books/hardcover/9780691249759/disrupting-dc), a ainsi converti toute une génération au dogme néolibéral : poser la privatisation comme axiome, et considérer la puissance publique comme une relique du vieux monde.  

[![Comment la crise de 2008 a influencé toute l'esthétique "Airspace" de la décennie 2010](https://api.arretsurimages.net/api/public/media/comment-la-crise-de-2008-a-influence-toute-lesthetique-airspace-de-la-decennie-2010/action/show?format=public&t=2024-01-25T18:02:58+01:00)](https://api.arretsurimages.net/api/public/media/comment-la-crise-de-2008-a-influence-toute-lesthetique-airspace-de-la-decennie-2010/action/show?format=public&t=2024-01-25T18:02:58+01:00)

### Comment la crise de 2008 a influencé toute l'esthétique "Airspace" de la décennie 2010

Vox, 27 décembre 2018  

Aujourd'hui, la bamboche est terminée. Depuis la pandémie, [écrit _Wired_](https://www.wired.com/story/rising-interest-rates-might-herald-the-end-of-the-open-internet/), les mêmes banques centrales dont les choix politiques de 2008 ont accouché du web 2.0 sont tout simplement en train de nous en sortir brutalement. Le taux d'emprunt étasunien est actuellement à 5 %, au plus haut depuis 2006. L'argent a cessé d'être gratuit. Conséquence immédiate : en 2022, les Gafam perdaient de 30 à 60 % de leur capitalisation boursière. Depuis deux ans, l'industrie de la tech étasunienne a licencié [près de 450 000 personnes](https://layoffs.fyi/#tabs_desc_471_2). Ce n'est pas que [_"l'Internet des trentenaires"_](https://www.ladn.eu/media-mutants/internet-trentenaires-disparaitre/) décrit par David-Julien Rahmil pour l'_ADN_ qui est en train de crever : le _millennial lifestyle_, son équivalent physique, meurt en même temps que ses plateformes, nous prévenaient [_The Atlantic_](https://www.theatlantic.com/newsletters/archive/2022/06/uber-ride-share-prices-high-inflation/661250/) et [le _New York Times_](https://www.nytimes.com/2021/06/08/technology/farewell-millennial-lifestyle-subsidy.html) l'année passée. Le quotidien s'emmerdifie à son tour. L'addition réelle est enfin arrivée, et ça pique. Un Uber coûte aussi cher qu'un taxi, un Airbnb coûte plus cher qu'un hôtel (142 euros par nuit en moyenne, augmentation de 36% entre 2019 et 2022). Cerise sur le gâteau : dix ans après, aucune des deux entreprises n'arrive à dégager un profit stable, même [en tordant leurs bilans financiers autant que possible](https://doctorow.medium.com/no-ubers-still-not-profitable-2b8054e375ea). _Bullshit_ un jour, _bullshit_ toujours.  

[![Adieu, quotidien millennial subventionné](https://api.arretsurimages.net/api/public/media/capture-decran-du-2024-01-25-18-03-25/action/show?format=public&t=2024-01-25T18:04:32+01:00)](https://api.arretsurimages.net/api/public/media/capture-decran-du-2024-01-25-18-03-25/action/show?format=public&t=2024-01-25T18:04:32+01:00)

### Adieu, quotidien millennial subventionné  

The New York Times, 8 juin 2021  

Ce qui reste, en revanche, c'est l'inféodation des politiques publiques aux priorités de l'oligarchie actionnariale, l'accélération de la casse du salariat et la création _ex nihilo,_ en quelques années à peine, [d'une nouvelle classe mondiale de prolétaires](https://www.radiofrance.fr/franceculture/podcasts/la-vie-numerique/les-travailleurs-du-clic-ces-humains-caches-dans-les-machines-4016850). Ce sont ces légions de chauffeurs Uber, travailleurs du clic, employés de _dark kitchens_, micro-tâcherons d'Amazon Turk, [modérateurs d'IA au Kenya, au Mexique, au Nigeria ou aux Philippines](https://restofworld.org/2023/ai-revolution-outsourced-workers/), livreurs à vélo, préparateurs de commandes Amazon et _gig workers_, sans protection sociale (et de plus en plus souvent sans titre de séjour), précarisés jusqu'à l'os, soumis quotidiennement à l'inhumanité d'un management algorithmique et dont le travail ne coûte virtuellement rien à des entreprises qui se paient simultanément le luxe d'ignorer les impôts locaux. La disruption, c'est ça et rien d'autre.  

Il est grand temps de dire les termes : la _gig economy_ des années 2010 est un net négatif pour le bien commun, une arnaque à échelle mondiale. Partout où elle passe, le service public ne repousse plus. Le véritable talent de la techno-élite, cette classe de rentiers parasites dont Elon Musk est le plus répugnant exemple, c'est d'avoir su constamment réécrire une histoire d'exploitation, de fraude et d'opportunisme financier en une grande épopée entrepreneuriale portée par des idéaux humanistes et révolutionnaires, et d'adapter constamment le récit de sa domination aux crises qui la menacent. En 2024, nous vivons désormais sous un régime économique [plus proche du féodalisme que de l'économie de marché libérale](https://www.editionsladecouverte.fr/technofeodalisme-9782355221156), mais il y a encore des serfs (et certains ont même la carte de presse) pour défendre avec entrain ce braquage planétaire des ressources au nom du futur libertarien, suprémaciste et colonial de nos seigneurs, une _keynote_ après l'autre.  

Dernière victime de l'emmerdification généralisée du web millennial : l'information. À ce titre, 2023 est peut-être bien le chant du cygne pour une génération de journalistes web, celle venue au métier avec les _pure players_ de la fin des années 2000 –notamment un certain _Arrêt sur Images,_ lancé en 2007. En 2010, la _Croix_ décrivait cette effervescence comme _["un fait majeur"](https://www.la-croix.com/Culture/Actualite/Les-pure-players-l-information-100-Web-_NG_-2010-12-29-561067)_ de la reconfiguration de l'information. Quinze ans plus tard, que – ou plutôt qui – reste-t-il ? Plus grand monde. Konbini [a frôlé le dépôt de bilan](https://www.capital.fr/entreprises-marches/konbini-se-place-sous-mandat-ad-hoc-1380937) en 2020. _BuzzFeed_ et _Vice_ ont fermé [en 2018](https://www.telerama.fr/medias/comment-buzzfeed-a-reussi-a-fermer-sa-filiale-francaise-du-jour-au-lendemain,-ou-presque,n5791735.php) et 2023, tout comme _Brain_, [vitrine de l'intellol hipster des années 2010](https://gonzai.com/rupture-danevrisme-pour-brain-magazine/). Pour l'information gratuite aussi, le mirage économique des années 2010 a fini par se dissiper. (Je ne vous apprends rien, chèr·es abonné·es : un journaliste travaille mieux quand il est payé et indépendant des soubresauts de Facebook).  

[![Le pure player, parangon de la modernité journalistique de 2010](https://api.arretsurimages.net/api/public/media/le-pure-player-parangon-de-la-modernite-journalistique-de-2010/action/show?format=public&t=2024-01-25T18:06:09+01:00)](https://api.arretsurimages.net/api/public/media/le-pure-player-parangon-de-la-modernite-journalistique-de-2010/action/show?format=public&t=2024-01-25T18:06:09+01:00)

### Le pure player, parangon de la modernité journalistique de 2010

La Croix, 28 décembre 2012  

Pour ne rien arranger, rappelle le techno-critique Hubert Guillaud [dans une excellente synthèse,](https://hubertguillaud.wordpress.com/2024/01/11/leffondrement-de-linformation/) Facebook, Twitter et les autres ont tout simplement [arrêté d'essayer de diffuser de l'information](https://www.theatlantic.com/technology/archive/2023/11/social-media-news-readership-decline/675890/) – trop compliqué, trop coûteux, trop risqué. Résultat : depuis la pandémie, l'actualité a en partie été effacée des flux de contenu, constate [le _New York Times_.](https://www.nytimes.com/2023/10/19/technology/news-social-media-traffic.html) En juillet, lorsque Facebook a décidé d'abandonner l'information au profit des tabloïds, _Business Insider_ ou _BuzzFeed_ [ont perdu 70 à 80 % de leur trafic.](https://www.ladn.eu/media-mutants/facebook-a-t-il-tue-la-presse-pour-de-bon-sur-sa-plateforme/) La tendance est générale. Le Pew Research Center [affirmait en octobre 2023](https://www.pewresearch.org/short-reads/2023/10/24/americans-are-following-the-news-less-closely-than-they-used-to/) qu'il n'y a jamais eu aussi peu d'Américains consommateurs réguliers d'information (38 % contre 52 % en 2018). Le trafic généré par les agrégateurs de _news_ [stagne, voire ralentit](https://digiday.com/media/as-news-aggregator-referral-traffic-slips-publishers-turn-their-attention-inward/?).  Et puis il reste Twitter, dont l'emmerdification homérique [a tout emporté  sur son passage](https://www.theverge.com/c/features/23993135/twitter-breaking-news-history) : le factuel, la réalité consensuelle, l'information, la confiance, l'actualité, le pluralisme d'idées. Notre génération a commis l'erreur de confondre multinationale et espace public, [dirait Olivier Ertzscheid](https://aoc.media/opinion/2023/09/17/ouvrir-le-code-des-algorithmes-ne-suffit-plus/). Voilà ce qui arrive lorsqu'on confie des responsabilités à l'homme le plus riche du monde.  

[![Comment Twitter a brisé l'information](https://api.arretsurimages.net/api/public/media/comment-twitter-a-brise-linformation/action/show?format=public&t=2024-01-25T18:07:41+01:00)](https://api.arretsurimages.net/api/public/media/comment-twitter-a-brise-linformation/action/show?format=public&t=2024-01-25T18:07:41+01:00)

### Comment Twitter a brisé l'information

The Verge, 12 décembre 2023  

Dans un écosystème informationnel emmerdifié au-delà du secourable, le public semble avoir atteint un point de saturation, et troqué la connaissance de l'actualité contre la sauvegarde de la santé mentale. Sur les réseaux sociaux, tout le monde se fout d'être informé. Et c'est peut-être alors de là que vient ce sentiment diffus de fin des temps qui semble toucher une partie de mes collègues, qui se demandent peut-être à quoi ils servent dans ce web-là. L'emmerdification généralisée [a fait de nous des apatrides,](https://www.wired.com/story/first-gen-social-media-users-have-nowhere-to-go/) écrit _Wired_. Nous voilà désorientés, obligés de désapprendre tous les réflexes, tous les usages que nous avons contribué à bâtir, sans savoir vraiment par quoi les remplacer. Sans savoir où aller. _"Le vieux monde se meurt, le nouveau monde tarde à apparaître, et entre les deux surgissent les monstres"_, disait Gramsci.  Ces monstres, ce sont les _millennials_ paumés, errant comme des âmes damnées dans un espace numérique dont ils ne parlent plus la langue. Le futur du web ne nous appartient plus.  

[![Les précurseurs du web social n'ont nulle part où aller](https://api.arretsurimages.net/api/public/media/les-precurseurs-du-web-social-nont-nulle-part-ou-aller/action/show?format=public&t=2024-01-25T18:10:10+01:00)](https://api.arretsurimages.net/api/public/media/les-precurseurs-du-web-social-nont-nulle-part-ou-aller/action/show?format=public&t=2024-01-25T18:10:10+01:00)

### Les précurseurs du web social n'ont nulle part où aller

Wired, 6 novembre 2023
